/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.api.fish.FishData;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.AquacultureSounds;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WormFarmBlock
extends ComposterBlock {
    public WormFarmBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.6f).func_200947_a(SoundType.field_185848_a));
    }

    public static void addCompostables() {
        WormFarmBlock.registerCompostable(AquaItems.ALGAE.func_199767_j(), 0.3f);
        if (((Boolean)AquaConfig.BASIC_OPTIONS.compostableFish.get()).booleanValue()) {
            for (Item fish : AquacultureAPI.FISH_DATA.getFish()) {
                double weight = AquacultureAPI.FISH_DATA.getMinWeight(fish);
                ItemStack fishStack = new ItemStack((IItemProvider)fish);
                if (fishStack.func_77978_p() != null && fishStack.func_77978_p().func_74764_b("fishWeight")) {
                    weight = fishStack.func_77978_p().func_74769_h("fishWeight");
                }
                float chance = MathHelper.func_76131_a((float)((float)FishData.getFilletAmountFromWeight(weight) * 0.25f), (float)0.05f, (float)0.65f);
                WormFarmBlock.registerCompostable(fish, chance);
            }
        }
    }

    public static void registerCompostable(Item item, float chance) {
        if (!field_220299_b.containsKey((Object)item) && field_220299_b.size() < 256) {
            field_220299_b.put((Object)item, chance);
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, BlockRayTraceResult raytrace) {
        int level = (Integer)state.func_177229_b((Property)field_220298_a);
        ItemStack heldStack = player.func_184586_b(hand);
        if (field_220299_b.containsKey((Object)heldStack.func_77973_b())) {
            if (level < 8 && !world.field_72995_K) {
                boolean addItem = WormFarmBlock.addItem(state, (IWorld)world, pos, heldStack);
                world.func_217379_c(1500, pos, addItem ? 1 : 0);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (level > 0) {
            if (!world.field_72995_K) {
                double x = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                double y = (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double z = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, new ItemStack((IItemProvider)AquaItems.WORM));
                itemEntity.func_174869_p();
                world.func_217376_c((Entity)itemEntity);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_220298_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)field_220298_a) - 1)), 3);
            world.func_184133_a(null, pos, AquacultureSounds.WORM_FARM_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_225534_a_(BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, Random random) {
    }

    private static boolean addItem(BlockState state, IWorld world, BlockPos pos, @Nonnull ItemStack stack) {
        int level = (Integer)state.func_177229_b((Property)field_220298_a);
        float chance = field_220299_b.getFloat((Object)stack.func_77973_b());
        if ((level != 0 || chance <= 0.0f) && world.func_201674_k().nextDouble() >= (double)chance) {
            return false;
        }
        int levelAdd = level + 1;
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_220298_a, (Comparable)Integer.valueOf(levelAdd)), 3);
        if (levelAdd == 7) {
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 20);
        }
        return true;
    }

    @Nonnull
    public ISidedInventory func_219966_a(BlockState state, @Nonnull IWorld world, @Nonnull BlockPos pos) {
        int level = (Integer)state.func_177229_b((Property)field_220298_a);
        if (level == 8) {
            return new FullInventory(state, world, pos, new ItemStack((IItemProvider)AquaItems.WORM));
        }
        return level < 7 ? new PartialInventory(state, world, pos) : new EmptyInventory();
    }

    static class EmptyInventory
    extends Inventory
    implements ISidedInventory {
        EmptyInventory() {
            super(0);
        }

        @Nonnull
        public int[] func_180463_a(@Nonnull Direction direction) {
            return new int[0];
        }

        public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }
    }

    static class FullInventory
    extends Inventory
    implements ISidedInventory {
        private final BlockState state;
        private final IWorld world;
        private final BlockPos pos;
        private boolean extracted;

        FullInventory(BlockState state, IWorld world, BlockPos pos, @Nonnull ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int func_70297_j_() {
            return 1;
        }

        @Nonnull
        public int[] func_180463_a(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return !this.extracted && direction == Direction.DOWN && stack.func_77973_b() == AquaItems.WORM;
        }

        public void func_70296_d() {
            this.world.func_180501_a(this.pos, (BlockState)this.state.func_206870_a((Property)ComposterBlock.field_220298_a, (Comparable)Integer.valueOf(0)), 3);
            this.extracted = true;
        }
    }

    static class PartialInventory
    extends Inventory
    implements ISidedInventory {
        private final BlockState state;
        private final IWorld world;
        private final BlockPos pos;
        private boolean inserted;

        PartialInventory(BlockState state, IWorld world, BlockPos pos) {
            super(1);
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int func_70297_j_() {
            return 1;
        }

        @Nonnull
        public int[] func_180463_a(@Nonnull Direction direction) {
            int[] nArray;
            if (direction == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean func_180462_a(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
            return !this.inserted && direction == Direction.UP && ComposterBlock.field_220299_b.containsKey((Object)stack.func_77973_b());
        }

        public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
            return false;
        }

        public void func_70296_d() {
            ItemStack stack = this.func_70301_a(0);
            if (!stack.func_190926_b()) {
                this.inserted = true;
                WormFarmBlock.addItem(this.state, this.world, this.pos, stack);
                this.func_70304_b(0);
            }
        }
    }
}

