/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.NovaExplosion;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.NetherRootsBlock;
import net.minecraft.block.NetherSproutsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.NetherrackBlock;
import net.minecraft.block.NyliumBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public final class WorldHelper {
    private static final Predicate<Entity> SWRG_REPEL_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_SWRG);
    private static final Predicate<Entity> INTERDICTION_REPEL_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_INTERDICTION);
    private static final Predicate<Entity> INTERDICTION_REPEL_HOSTILE_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_INTERDICTION) && (entity instanceof IMob || entity instanceof ProjectileEntity);

    public static void createLootDrop(List<ItemStack> drops, World world, BlockPos pos) {
        WorldHelper.createLootDrop(drops, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void createLootDrop(List<ItemStack> drops, World world, double x, double y, double z) {
        if (!drops.isEmpty()) {
            ItemHelper.compactItemListNoStacksize(drops);
            for (ItemStack drop : drops) {
                world.func_217376_c((Entity)new ItemEntity(world, x, y, z, drop));
            }
        }
    }

    public static void createNovaExplosion(World world, Entity exploder, double x, double y, double z, float power) {
        NovaExplosion explosion = new NovaExplosion(world, exploder, x, y, z, power, true, Explosion.Mode.BREAK);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(world, (Explosion)explosion))) {
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
    }

    public static void drainFluid(World world, BlockPos pos, BlockState state, Fluid toMatch) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock && ((IFluidBlock)block).getFluid().func_207187_a(toMatch)) {
            ((IFluidBlock)block).drain(world, pos, IFluidHandler.FluidAction.EXECUTE);
        } else if (block instanceof IBucketPickupHandler) {
            ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, state);
        }
    }

    public static void dropInventory(IItemHandler inv, World world, BlockPos pos) {
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ItemEntity ent = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            ent.func_92058_a(stack);
            world.func_217376_c((Entity)ent);
        }
    }

    public static void extinguishNearby(World world, PlayerEntity player) {
        BlockPos.func_218281_b((BlockPos)player.func_233580_cy_().func_177982_a(-1, -1, -1), (BlockPos)player.func_233580_cy_().func_177982_a(1, 1, 1)).forEach(pos -> {
            if (world.func_180495_p(pos = pos.func_185334_h()).func_177230_c() == Blocks.field_150480_ab && PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos)) {
                world.func_217377_a(pos, false);
            }
        });
    }

    public static void freezeInBoundingBox(World world, AxisAlignedBB box, PlayerEntity player, boolean random) {
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            pos = pos.func_185334_h();
            if (!(b != Blocks.field_150355_j || random && world.field_73012_v.nextInt(128) != 0)) {
                if (player != null) {
                    PlayerHelper.checkedReplaceBlock((ServerPlayerEntity)player, pos, Blocks.field_150432_aD.func_176223_P());
                    continue;
                }
                world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                continue;
            }
            if (!Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)world, pos.func_177977_b()), (Direction)Direction.UP)) continue;
            BlockPos up = pos.func_177984_a();
            BlockState stateUp = world.func_180495_p(up);
            BlockState newState = null;
            if (stateUp.func_177230_c().isAir(stateUp, (IBlockReader)world, up) && (!random || world.field_73012_v.nextInt(128) == 0)) {
                newState = Blocks.field_150433_aE.func_176223_P();
            } else if (stateUp.func_177230_c() == Blocks.field_150433_aE && (Integer)stateUp.func_177229_b((Property)SnowBlock.field_176315_a) < 8 && world.field_73012_v.nextInt(512) == 0) {
                newState = (BlockState)stateUp.func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf((Integer)stateUp.func_177229_b((Property)SnowBlock.field_176315_a) + 1));
            }
            if (newState == null) continue;
            if (player != null) {
                PlayerHelper.checkedReplaceBlock((ServerPlayerEntity)player, up, newState);
                continue;
            }
            world.func_175656_a(up, newState);
        }
    }

    public static boolean isLiquidContainerForFluid(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a(world, pos, state, fluid);
    }

    public static void placeFluid(@Nullable ServerPlayerEntity player, World world, BlockPos pos, Direction sideHit, FlowingFluid fluid, boolean checkWaterVaporize) {
        if (WorldHelper.isLiquidContainerForFluid((IBlockReader)world, pos, world.func_180495_p(pos), (Fluid)fluid)) {
            WorldHelper.placeFluid(player, world, pos, fluid, checkWaterVaporize);
        } else {
            WorldHelper.placeFluid(player, world, pos.func_177972_a(sideHit), fluid, checkWaterVaporize);
        }
    }

    public static void placeFluid(@Nullable ServerPlayerEntity player, World world, BlockPos pos, FlowingFluid fluid, boolean checkWaterVaporize) {
        BlockState blockState = world.func_180495_p(pos);
        if (checkWaterVaporize && world.func_230315_m_().func_236040_e_() && fluid.func_207185_a((ITag)FluidTags.field_206959_a)) {
            world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else if (WorldHelper.isLiquidContainerForFluid((IBlockReader)world, pos, blockState, (Fluid)fluid)) {
            ((ILiquidContainer)blockState.func_177230_c()).func_204509_a((IWorld)world, pos, blockState, fluid.func_207204_a(false));
        } else {
            Material material = blockState.func_185904_a();
            if (!(material.func_76220_a() && !material.func_76222_j() || material.func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            if (player == null) {
                world.func_175656_a(pos, fluid.func_207188_f().func_206883_i());
            } else {
                PlayerHelper.checkedPlaceBlock(player, pos, fluid.func_207188_f().func_206883_i());
            }
        }
    }

    @Nullable
    public static IItemHandler getItemHandler(@Nonnull TileEntity tile, @Nullable Direction direction) {
        Optional capability = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve();
        if (capability.isPresent()) {
            return (IItemHandler)capability.get();
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, direction);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    public static AxisAlignedBB getBroadDeepBox(BlockPos pos, Direction direction, int offset) {
        switch (direction) {
            case EAST: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case UP: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + offset));
            }
            case DOWN: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)pos.func_177952_p());
            }
            case NORTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)(pos.func_177956_o() - offset), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + offset), (double)(pos.func_177956_o() + offset), (double)(pos.func_177952_p() + offset));
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getDeepBox(BlockPos pos, Direction direction, int depth) {
        switch (direction) {
            case EAST: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - depth), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + depth), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
            }
            case UP: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - depth), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 1));
            }
            case DOWN: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + depth), (double)(pos.func_177952_p() + 1));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - depth), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p());
            }
            case NORTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + depth));
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getBroadBox(BlockPos pos, Direction direction, int size) {
        switch (direction) {
            case EAST: 
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() - size), (double)(pos.func_177952_p() - size), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + size), (double)(pos.func_177952_p() + size));
            }
            case UP: 
            case DOWN: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - size), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - size), (double)(pos.func_177958_n() + size), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + size));
            }
            case SOUTH: 
            case NORTH: {
                return new AxisAlignedBB((double)(pos.func_177958_n() - size), (double)(pos.func_177956_o() - size), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + size), (double)(pos.func_177956_o() + size), (double)pos.func_177952_p());
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getFlatYBox(BlockPos pos, int offset) {
        return new AxisAlignedBB((double)(pos.func_177958_n() - offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - offset), (double)(pos.func_177958_n() + offset), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + offset));
    }

    public static Iterable<BlockPos> getPositionsFromBox(AxisAlignedBB box) {
        return WorldHelper.getPositionsFromBox(new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c), new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    public static Iterable<BlockPos> getPositionsFromBox(BlockPos corner1, BlockPos corner2) {
        return () -> BlockPos.func_218281_b((BlockPos)corner1, (BlockPos)corner2).iterator();
    }

    public static List<TileEntity> getTileEntitiesWithinAABB(World world, AxisAlignedBB bBox) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            TileEntity tile = WorldHelper.getTileEntity((IBlockReader)world, pos);
            if (tile == null) continue;
            list.add(tile);
        }
        return list;
    }

    public static void gravitateEntityTowards(Entity ent, double x, double y, double z) {
        double dZ;
        double dY;
        double dX = x - ent.func_226277_ct_();
        double dist = Math.sqrt(dX * dX + (dY = y - ent.func_226278_cu_()) * dY + (dZ = z - ent.func_226281_cx_()) * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.func_213317_d(ent.func_213322_ci().func_72441_c(dX / dist * vel * 0.1, dY / dist * vel * 0.2, dZ / dist * vel * 0.1));
        }
    }

    public static void growNearbyRandomly(boolean harvest, World world, BlockPos pos, PlayerEntity player) {
        if (!(world instanceof ServerWorld)) {
            return;
        }
        int chance = harvest ? 16 : 32;
        for (BlockPos currentPos : WorldHelper.getPositionsFromBox(pos.func_177982_a(-5, -3, -5), pos.func_177982_a(5, 3, 5))) {
            BlockState state = world.func_180495_p(currentPos = currentPos.func_185334_h());
            Block crop = state.func_177230_c();
            if (crop instanceof IForgeShearable || crop instanceof FlowerBlock || crop instanceof DoublePlantBlock || crop instanceof NetherRootsBlock || crop instanceof NetherSproutsBlock) {
                if (!harvest) continue;
                WorldHelper.harvestBlock(world, currentPos, (ServerPlayerEntity)player);
                continue;
            }
            if (crop instanceof IGrowable) {
                IGrowable growable = (IGrowable)crop;
                if (!growable.func_176473_a((IBlockReader)world, currentPos, state, false)) {
                    if (!harvest || crop.func_203417_a(PETags.Blocks.BLACKLIST_HARVEST) || crop == Blocks.field_203215_jy && !world.func_180495_p(currentPos.func_177977_b()).func_203425_a(crop)) continue;
                    WorldHelper.harvestBlock(world, currentPos, (ServerPlayerEntity)player);
                    continue;
                }
                if (!ProjectEConfig.server.items.harvBandGrass.get() && WorldHelper.isGrassLikeBlock(crop) || world.field_73012_v.nextInt(chance) != 0) continue;
                growable.func_225535_a_((ServerWorld)world, world.field_73012_v, currentPos, state);
                continue;
            }
            if (!(crop instanceof IPlantable)) continue;
            if (world.field_73012_v.nextInt(chance / 4) == 0) {
                for (int i = 0; i < (harvest ? 8 : 4); ++i) {
                    state.func_227034_b_((ServerWorld)world, currentPos, world.field_73012_v);
                }
            }
            if (!harvest) continue;
            if (crop == Blocks.field_196608_cF || crop == Blocks.field_150434_aF) {
                int i;
                if (!world.func_180495_p(currentPos.func_177984_a()).func_203425_a(crop) || !world.func_180495_p(currentPos.func_177981_b(2)).func_203425_a(crop)) continue;
                int n = i = crop == Blocks.field_196608_cF ? 1 : 0;
                while (i < 3) {
                    WorldHelper.harvestBlock(world, currentPos.func_177981_b(i), (ServerPlayerEntity)player);
                    ++i;
                }
                continue;
            }
            if (crop != Blocks.field_150388_bm || (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) != 3) continue;
            WorldHelper.harvestBlock(world, currentPos, (ServerPlayerEntity)player);
        }
    }

    private static boolean isGrassLikeBlock(Block crop) {
        return crop instanceof GrassBlock || crop instanceof NyliumBlock || crop instanceof NetherrackBlock;
    }

    private static void harvestBlock(World world, BlockPos pos, @Nullable ServerPlayerEntity player) {
        if (player == null || PlayerHelper.hasBreakPermission(player, pos)) {
            world.func_225521_a_(pos, true, (Entity)player);
        }
    }

    public static int harvestVein(World world, PlayerEntity player, ItemStack stack, BlockPos pos, Block target, List<ItemStack> currentDrops, int numMined) {
        if (numMined >= 250) {
            return numMined;
        }
        AxisAlignedBB b = new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
        for (BlockPos currentPos : WorldHelper.getPositionsFromBox(b)) {
            BlockState currentState = world.func_180495_p(currentPos);
            if (currentState.func_177230_c() != target || !PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, currentPos = currentPos.func_185334_h())) continue;
            ++numMined;
            currentDrops.addAll(Block.func_220077_a((BlockState)currentState, (ServerWorld)((ServerWorld)world), (BlockPos)currentPos, (TileEntity)WorldHelper.getTileEntity((IBlockReader)world, currentPos), (Entity)player, (ItemStack)stack));
            world.func_217377_a(currentPos, false);
            if ((numMined = WorldHelper.harvestVein(world, player, stack, currentPos, target, currentDrops, numMined)) < 250) continue;
            break;
        }
        return numMined;
    }

    public static void igniteNearby(World world, PlayerEntity player) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)player.func_233580_cy_().func_177982_a(-8, -5, -8), (BlockPos)player.func_233580_cy_().func_177982_a(8, 5, 8))) {
            if (world.field_73012_v.nextInt(128) != 0 || !world.func_175623_d(pos)) continue;
            PlayerHelper.checkedPlaceBlock((ServerPlayerEntity)player, pos.func_185334_h(), Blocks.field_150480_ab.func_176223_P());
        }
    }

    private static boolean validRepelEntity(Entity entity, ITag<EntityType<?>> blacklistTag) {
        if (!entity.func_175149_v() && !entity.func_200600_R().func_220341_a(blacklistTag)) {
            if (entity instanceof ProjectileEntity) {
                return !entity.func_233570_aj_();
            }
            return entity instanceof MobEntity;
        }
        return false;
    }

    public static void repelEntitiesInterdiction(World world, AxisAlignedBB effectBounds, double x, double y, double z) {
        Vector3d vec = new Vector3d(x, y, z);
        Predicate<Entity> repelPredicate = ProjectEConfig.server.effects.interdictionMode.get() ? INTERDICTION_REPEL_HOSTILE_PREDICATE : INTERDICTION_REPEL_PREDICATE;
        for (Entity ent : world.func_175647_a(Entity.class, effectBounds, repelPredicate)) {
            WorldHelper.repelEntity(vec, ent);
        }
    }

    public static void repelEntitiesSWRG(World world, AxisAlignedBB effectBounds, PlayerEntity player) {
        Vector3d playerVec = player.func_213303_ch();
        for (Entity ent : world.func_175647_a(Entity.class, effectBounds, SWRG_REPEL_PREDICATE)) {
            if (ent instanceof ProjectileEntity) {
                Entity owner = ((ProjectileEntity)ent).func_234616_v_();
                if (world.func_201670_d() && owner == null || owner != null && player.func_110124_au().equals(owner.func_110124_au())) continue;
            }
            WorldHelper.repelEntity(playerVec, ent);
        }
    }

    private static void repelEntity(Vector3d vec, Entity entity) {
        Vector3d t = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        Vector3d r = new Vector3d(t.field_72450_a - vec.field_72450_a, t.field_72448_b - vec.field_72448_b, t.field_72449_c - vec.field_72449_c);
        double distance = vec.func_72438_d(t) + 0.1;
        entity.func_213317_d(entity.func_213322_ci().func_178787_e(r.func_186678_a(0.6666666666666666 / distance)));
    }

    @Nonnull
    public static ActionResultType igniteBlock(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        BlockState state = world.func_180495_p(pos);
        if (AbstractFireBlock.func_241465_a_((World)world, (BlockPos)pos, (Direction)side)) {
            if (!world.field_72995_K && PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos)) {
                world.func_175656_a(pos, AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)pos));
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.POWER.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else if (CampfireBlock.func_241470_h_((BlockState)state)) {
            if (!world.field_72995_K && PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos)) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.POWER.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else if (state.isFlammable((IBlockReader)world, pos, side)) {
            if (!world.field_72995_K && PlayerHelper.hasBreakPermission((ServerPlayerEntity)player, pos)) {
                state.catchFire(world, pos, side, (LivingEntity)player);
                if (state.func_177230_c() instanceof TNTBlock) {
                    world.func_217377_a(pos, false);
                }
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.POWER.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public static boolean isBlockLoaded(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    @Nullable
    public static TileEntity getTileEntity(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (!WorldHelper.isBlockLoaded(world, pos)) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos) {
        return WorldHelper.getTileEntity(clazz, world, pos, false);
    }

    @Nullable
    public static <T extends TileEntity> T getTileEntity(@Nonnull Class<T> clazz, @Nullable IBlockReader world, @Nonnull BlockPos pos, boolean logWrongType) {
        TileEntity tile = WorldHelper.getTileEntity(world, pos);
        if (tile == null) {
            return null;
        }
        if (clazz.isInstance(tile)) {
            return (T)((TileEntity)clazz.cast(tile));
        }
        if (logWrongType) {
            PECore.LOGGER.warn("Unexpected TileEntity class at {}, expected {}, but found: {}", (Object)pos, clazz, tile.getClass());
        }
        return null;
    }
}

