/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NovaExplosion
extends Explosion {
    private final World world;
    private final Explosion.Mode mode;
    private final double x;
    private final double y;
    private final double z;
    private final float size;

    public NovaExplosion(World world, @Nullable Entity entity, double x, double y, double z, float radius, boolean causesFire, Explosion.Mode mode) {
        super(world, entity, null, null, x, y, z, radius, causesFire, mode);
        this.world = world;
        this.mode = mode;
        this.size = radius;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean hasExplosionMode;
        if (this.world.field_72995_K) {
            this.world.func_184134_a(this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = hasExplosionMode = this.mode != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (hasExplosionMode && this.size >= 2.0f) {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (hasExplosionMode) {
            NonNullList allDrops = NonNullList.func_191196_a();
            List affectedBlockPositions = this.func_180343_e();
            Collections.shuffle(affectedBlockPositions, this.world.field_73012_v);
            for (BlockPos pos : affectedBlockPositions) {
                BlockState state = this.world.func_180495_p(pos);
                if (state.isAir((IBlockReader)this.world, pos)) continue;
                if (spawnParticles) {
                    double adjustedX = (float)pos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double adjustedY = (float)pos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double adjustedZ = (float)pos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double diffX = adjustedX - this.x;
                    double diffY = adjustedY - this.y;
                    double diffZ = adjustedZ - this.z;
                    double diff = MathHelper.func_76133_a((double)(diffX * diffX + diffY * diffY + diffZ * diffZ));
                    diffX /= diff;
                    diffY /= diff;
                    diffZ /= diff;
                    double d7 = 0.5 / (diff / (double)this.size + 0.1);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (adjustedX + this.x) / 2.0, (adjustedY + this.y) / 2.0, (adjustedZ + this.z) / 2.0, diffX *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), diffY *= d7, diffZ *= d7);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, adjustedX, adjustedY, adjustedZ, diffX, diffY, diffZ);
                }
                pos = pos.func_185334_h();
                this.world.func_217381_Z().func_76320_a("explosion_blocks");
                if (this.world instanceof ServerWorld && state.canDropFromExplosion((IBlockReader)this.world, pos, (Explosion)this)) {
                    TileEntity tileentity = state.hasTileEntity() ? WorldHelper.getTileEntity((IBlockReader)this.world, pos) : null;
                    LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.getExploder());
                    if (this.mode == Explosion.Mode.DESTROY) {
                        builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.size));
                    }
                    allDrops.addAll((Collection)state.func_215693_a(builder));
                }
                state.onBlockExploded(this.world, pos, (Explosion)this);
                this.world.func_217381_Z().func_76319_b();
            }
            LivingEntity placer = this.func_94613_c();
            if (placer == null) {
                WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.world, this.x, this.y, this.z);
            } else {
                WorldHelper.createLootDrop((List<ItemStack>)allDrops, this.world, placer.func_233580_cy_());
            }
        }
    }
}

