/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.utils.Comparators;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class ItemHelper {
    public static ActionResult<ItemStack> actionResultFromType(ActionResultType type, ItemStack stack) {
        switch (type) {
            case SUCCESS: {
                return ActionResult.func_226248_a_((Object)stack);
            }
            case CONSUME: {
                return ActionResult.func_226249_b_((Object)stack);
            }
            case FAIL: {
                return ActionResult.func_226251_d_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77989_b((ItemStack)ItemHelper.getNormalizedStack(stack1), (ItemStack)ItemHelper.getNormalizedStack(stack2));
    }

    public static boolean checkItemNBT(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_196082_o().func_74767_n(key);
    }

    public static boolean compactInventory(IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            temp.add(stackInSlot);
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (ItemStack s : temp) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)s, (boolean)false);
        }
        return temp.isEmpty();
    }

    public static void compactItemListNoStacksize(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            if (s.func_190926_b()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                ItemStack s1 = list.get(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)s1)) continue;
                s.func_190917_f(s1.func_190916_E());
                list.set(j, ItemStack.field_190927_a);
            }
        }
        list.removeIf(ItemStack::func_190926_b);
        list.sort(Comparators.ITEMSTACK_ASCENDING);
    }

    @Nullable
    public static CompoundNBT copyNBTSkipKey(@Nonnull CompoundNBT nbt, @Nonnull String keyToSkip) {
        CompoundNBT copiedNBT = new CompoundNBT();
        for (String key : nbt.func_150296_c()) {
            INBT innerNBT;
            if (keyToSkip.equals(key) || (innerNBT = nbt.func_74781_a(key)) == null) continue;
            copiedNBT.func_218657_a(key, innerNBT.func_74737_b());
        }
        if (copiedNBT.isEmpty()) {
            return null;
        }
        return copiedNBT;
    }

    public static ItemStack getNormalizedStack(ItemStack stack) {
        return ItemHelper.size(stack, 1);
    }

    public static IItemHandlerModifiable immutableCopy(IItemHandler toCopy) {
        final ArrayList<ItemStack> list = new ArrayList<ItemStack>(toCopy.getSlots());
        for (int i = 0; i < toCopy.getSlots(); ++i) {
            list.add(toCopy.getStackInSlot(i));
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            }

            public int getSlots() {
                return list.size();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)list.get(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return this.getStackInSlot(slot).func_77976_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    public static boolean isOre(BlockState state) {
        return state.func_235714_a_((ITag)Tags.Blocks.ORES);
    }

    public static boolean isOre(Block b) {
        return Tags.Blocks.ORES.func_230235_a_((Object)b);
    }

    public static boolean isOre(Item i) {
        return ItemHelper.isOre(Block.func_149634_a((Item)i));
    }

    public static boolean isRepairableDamagedItem(ItemStack stack) {
        return stack.func_77984_f() && stack.isRepairable() && stack.func_77952_i() > 0;
    }

    public static int simulateFit(NonNullList<ItemStack> inv, ItemStack stack) {
        int remainder = stack.func_190916_E();
        for (ItemStack invStack : inv) {
            int amountSlotNeeds;
            if (invStack.func_190926_b()) {
                return 0;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack) || (amountSlotNeeds = invStack.func_77976_d() - invStack.func_190916_E()) <= 0) continue;
            if (remainder <= amountSlotNeeds) {
                return 0;
            }
            remainder -= amountSlotNeeds;
        }
        return remainder;
    }

    @Nullable
    public static CompoundNBT recombineNBT(List<CompoundNBT> pieces) {
        if (pieces.isEmpty()) {
            return null;
        }
        CompoundNBT combinedNBT = pieces.get(0);
        for (int i = 1; i < pieces.size(); ++i) {
            combinedNBT = combinedNBT.func_197643_a(pieces.get(i));
        }
        return combinedNBT;
    }

    public static ItemStack size(ItemStack stack, int size) {
        if (size <= 0 || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    public static BlockState stackToState(ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        }
        return null;
    }
}

