/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.world_transmute;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import moze_intel.projecte.api.imc.WorldTransmutationEntry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldTransmuteEntry {
    private final ItemStack inputItem;
    private final ItemStack leftOutputItem;
    private final ItemStack rightOutputItem;
    private final FluidStack inputFluid;
    private final FluidStack leftOutputFluid;
    private final FluidStack rightOutputFluid;

    public WorldTransmuteEntry(WorldTransmutationEntry transmutationEntry) {
        Block inputBlock = transmutationEntry.getOrigin().func_177230_c();
        BlockState leftOutput = transmutationEntry.getResult();
        BlockState rightOutput = transmutationEntry.getAltResult();
        this.inputFluid = this.fluidFromBlock(inputBlock);
        this.inputItem = this.inputFluid == null ? this.itemFromBlock(inputBlock, transmutationEntry.getOrigin()) : ItemStack.field_190927_a;
        if (leftOutput != null) {
            this.leftOutputFluid = this.fluidFromBlock(leftOutput.func_177230_c());
            this.leftOutputItem = this.leftOutputFluid == null ? this.itemFromBlock(leftOutput.func_177230_c(), leftOutput) : ItemStack.field_190927_a;
        } else {
            this.leftOutputItem = ItemStack.field_190927_a;
            this.leftOutputFluid = FluidStack.EMPTY;
        }
        if (rightOutput != null) {
            this.rightOutputFluid = this.fluidFromBlock(rightOutput.func_177230_c());
            this.rightOutputItem = this.rightOutputFluid == null ? this.itemFromBlock(rightOutput.func_177230_c(), rightOutput) : ItemStack.field_190927_a;
        } else {
            this.rightOutputItem = ItemStack.field_190927_a;
            this.rightOutputFluid = FluidStack.EMPTY;
        }
    }

    private FluidStack fluidFromBlock(Block block) {
        if (block instanceof FlowingFluidBlock) {
            return new FluidStack((Fluid)((FlowingFluidBlock)block).getFluid(), 1000);
        }
        if (block instanceof IFluidBlock) {
            return new FluidStack(((IFluidBlock)block).getFluid(), 1000);
        }
        return null;
    }

    private ItemStack itemFromBlock(Block block, BlockState state) {
        try {
            return block.getPickBlock(state, null, null, null, null);
        }
        catch (Exception e) {
            return new ItemStack((IItemProvider)block);
        }
    }

    public boolean isRenderable() {
        boolean hasInput = this.inputFluid != null || !this.inputItem.func_190926_b();
        boolean hasLeftOutput = this.leftOutputFluid != null || !this.leftOutputItem.func_190926_b();
        boolean hasRightOutput = this.rightOutputFluid != null || !this.rightOutputItem.func_190926_b();
        return hasInput && (hasLeftOutput || hasRightOutput);
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        if (this.inputFluid != null) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.inputFluid);
        } else if (!this.inputItem.func_190926_b()) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.inputItem);
        }
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        if (this.leftOutputFluid != null) {
            fluidOutputs.add(this.leftOutputFluid);
        }
        if (this.rightOutputFluid != null) {
            fluidOutputs.add(this.rightOutputFluid);
        }
        if (!fluidOutputs.isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, fluidOutputs);
        }
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (!this.leftOutputItem.func_190926_b()) {
            outputList.add(this.leftOutputItem);
        }
        if (!this.rightOutputItem.func_190926_b()) {
            outputList.add(this.rightOutputItem);
        }
        if (!outputList.isEmpty()) {
            ingredients.setOutputs(VanillaTypes.ITEM, outputList);
        }
    }

    public ItemStack getInputItem() {
        return this.inputItem;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }
}

