/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.integration.jei.collectors.CollectorRecipeCategory;
import moze_intel.projecte.integration.jei.collectors.FuelUpgradeRecipe;
import moze_intel.projecte.integration.jei.world_transmute.WorldTransmuteRecipeCategory;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class PEJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = PECore.rl("main");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new WorldTransmuteRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CollectorRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(PhilosStoneContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(PEItems.PHILOSOPHERS_STONE), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING, WorldTransmuteRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack(PEBlocks.COLLECTOR), new ResourceLocation[]{CollectorRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack(PEBlocks.COLLECTOR_MK2), new ResourceLocation[]{CollectorRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack(PEBlocks.COLLECTOR_MK3), new ResourceLocation[]{CollectorRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(WorldTransmuteRecipeCategory.getAllTransmutations(), WorldTransmuteRecipeCategory.UID);
        ArrayList<FuelUpgradeRecipe> fuelRecipes = new ArrayList<FuelUpgradeRecipe>();
        for (Item i : FuelMapper.getFuelMap()) {
            ItemStack stack = new ItemStack((IItemProvider)i);
            ItemStack fuelUpgrade = FuelMapper.getFuelUpgrade(stack);
            if (EMCHelper.getEmcValue(stack) > EMCHelper.getEmcValue(fuelUpgrade)) continue;
            fuelRecipes.add(new FuelUpgradeRecipe(stack, fuelUpgrade));
        }
        registry.addRecipes(fuelRecipes, CollectorRecipeCategory.UID);
    }
}

