/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.gameObjs.container.CondenserMK2Container;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CondenserMK2Tile
extends CondenserTile {
    public CondenserMK2Tile() {
        super((TileEntityType)PETileEntityTypes.CONDENSER_MK2.get());
    }

    @Override
    @Nonnull
    protected IItemHandler createAutomationInventory() {
        WrappedItemHandler automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.getInput(), WrappedItemHandler.WriteMode.IN){

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserMK2Tile.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        WrappedItemHandler automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.getOutput(), WrappedItemHandler.WriteMode.OUT);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{automationInput, automationOutput});
    }

    @Override
    protected ItemStackHandler createInput() {
        return new TileEmc.StackHandler(this, 42);
    }

    @Override
    protected ItemStackHandler createOutput() {
        return new TileEmc.StackHandler(this, 42);
    }

    @Override
    protected void condense() {
        while (this.hasSpace() && this.getStoredEmc() >= this.requiredEmc) {
            this.pushStack();
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
        }
        if (this.hasSpace()) {
            for (int i = 0; i < this.getInput().getSlots(); ++i) {
                ItemStack stack = this.getInput().getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                this.forceInsertEmc(EMCHelper.getEmcSellValue(stack) * (long)stack.func_190916_E(), IEmcStorage.EmcAction.EXECUTE);
                this.getInput().setStackInSlot(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.getOutput().deserializeNBT(nbt.func_74775_l("Output"));
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_218657_a("Output", (INBT)this.getOutput().serializeNBT());
        return nbt;
    }

    @Override
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInv, @Nonnull PlayerEntity player) {
        return new CondenserMK2Container(windowId, playerInv, this);
    }

    @Override
    @Nonnull
    public ITextComponent func_145748_c_() {
        return TextComponentUtil.build(PEBlocks.CONDENSER_MK2);
    }
}

