/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registries;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.EnumFuelType;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.blocks.AlchemicalChest;
import moze_intel.projecte.gameObjs.blocks.Collector;
import moze_intel.projecte.gameObjs.blocks.Condenser;
import moze_intel.projecte.gameObjs.blocks.CondenserMK2;
import moze_intel.projecte.gameObjs.blocks.InterdictionTorch;
import moze_intel.projecte.gameObjs.blocks.InterdictionTorchWall;
import moze_intel.projecte.gameObjs.blocks.MatterBlock;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.blocks.Pedestal;
import moze_intel.projecte.gameObjs.blocks.ProjectETNT;
import moze_intel.projecte.gameObjs.blocks.Relay;
import moze_intel.projecte.gameObjs.blocks.TransmutationStone;
import moze_intel.projecte.gameObjs.entity.EntityNovaCataclysmPrimed;
import moze_intel.projecte.gameObjs.entity.EntityNovaCatalystPrimed;
import moze_intel.projecte.gameObjs.items.blocks.CollectorItem;
import moze_intel.projecte.gameObjs.items.blocks.ItemFuelBlock;
import moze_intel.projecte.gameObjs.items.blocks.RelayItem;
import moze_intel.projecte.gameObjs.registration.impl.BlockDeferredRegister;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ItemDeferredRegister;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.common.ToolType;

public class PEBlocks {
    public static final BlockDeferredRegister BLOCKS = new BlockDeferredRegister();
    public static final BlockRegistryObject<AlchemicalChest, BlockItem> ALCHEMICAL_CHEST = BLOCKS.register("alchemical_chest", () -> new AlchemicalChest(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(10.0f, 3600000.0f)));
    public static final BlockRegistryObject<Block, ItemFuelBlock> ALCHEMICAL_COAL = PEBlocks.registerFuelBlock("alchemical_coal_block", EnumFuelType.ALCHEMICAL_COAL);
    public static final BlockRegistryObject<Block, ItemFuelBlock> MOBIUS_FUEL = PEBlocks.registerFuelBlock("mobius_fuel_block", EnumFuelType.MOBIUS_FUEL);
    public static final BlockRegistryObject<Block, ItemFuelBlock> AETERNALIS_FUEL = PEBlocks.registerFuelBlock("aeternalis_fuel_block", EnumFuelType.AETERNALIS_FUEL);
    public static final BlockRegistryObject<Collector, CollectorItem> COLLECTOR = PEBlocks.registerCollector("collector_mk1", EnumCollectorTier.MK1, state -> 7);
    public static final BlockRegistryObject<Collector, CollectorItem> COLLECTOR_MK2 = PEBlocks.registerCollector("collector_mk2", EnumCollectorTier.MK2, state -> 11);
    public static final BlockRegistryObject<Collector, CollectorItem> COLLECTOR_MK3 = PEBlocks.registerCollector("collector_mk3", EnumCollectorTier.MK3, state -> 15);
    public static final BlockRegistryObject<Condenser, BlockItem> CONDENSER = PEBlocks.registerCondenser("condenser_mk1", Condenser::new, block -> new BlockItem((Block)block, ItemDeferredRegister.getBaseProperties()));
    public static final BlockRegistryObject<CondenserMK2, BlockItem> CONDENSER_MK2 = PEBlocks.registerCondenser("condenser_mk2", CondenserMK2::new, block -> new BlockItem((Block)block, ItemDeferredRegister.getBaseProperties().func_234689_a_()));
    public static final BlockRegistryObject<Pedestal, BlockItem> DARK_MATTER_PEDESTAL = BLOCKS.register("dm_pedestal", () -> new Pedestal(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(1.0f, 3.0f).func_235838_a_(state -> 12)), block -> new BlockItem((Block)block, ItemDeferredRegister.getBaseProperties().func_234689_a_()));
    public static final BlockRegistryObject<MatterFurnace, BlockItem> DARK_MATTER_FURNACE = PEBlocks.registerFurnace("dm_furnace", EnumMatterType.DARK_MATTER, 1000000.0f, 3000000.0f);
    public static final BlockRegistryObject<MatterFurnace, BlockItem> RED_MATTER_FURNACE = PEBlocks.registerFurnace("rm_furnace", EnumMatterType.RED_MATTER, 2000000.0f, 6000000.0f);
    public static final BlockRegistryObject<MatterBlock, BlockItem> DARK_MATTER = PEBlocks.registerMatterBlock("dark_matter_block", EnumMatterType.DARK_MATTER, 1000000.0f, 3000000.0f);
    public static final BlockRegistryObject<MatterBlock, BlockItem> RED_MATTER = PEBlocks.registerMatterBlock("red_matter_block", EnumMatterType.RED_MATTER, 2000000.0f, 6000000.0f);
    public static final BlockRegistryObject.WallOrFloorBlockRegistryObject<InterdictionTorch, InterdictionTorchWall, WallOrFloorItem> INTERDICTION_TORCH = BLOCKS.registerWallOrFloorItem("interdiction_torch", InterdictionTorch::new, InterdictionTorchWall::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_235838_a_(state -> 14).func_200944_c());
    public static final BlockRegistryObject<ProjectETNT, BlockItem> NOVA_CATALYST = PEBlocks.registerExplosive("nova_catalyst", EntityNovaCatalystPrimed::new);
    public static final BlockRegistryObject<ProjectETNT, BlockItem> NOVA_CATACLYSM = PEBlocks.registerExplosive("nova_cataclysm", EntityNovaCataclysmPrimed::new);
    public static final BlockRegistryObject<TransmutationStone, BlockItem> TRANSMUTATION_TABLE = BLOCKS.register("transmutation_table", () -> new TransmutationStone(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(10.0f, 30.0f)));
    public static final BlockRegistryObject<Relay, RelayItem> RELAY = PEBlocks.registerRelay("relay_mk1", EnumRelayTier.MK1, state -> 7);
    public static final BlockRegistryObject<Relay, RelayItem> RELAY_MK2 = PEBlocks.registerRelay("relay_mk2", EnumRelayTier.MK2, state -> 11);
    public static final BlockRegistryObject<Relay, RelayItem> RELAY_MK3 = PEBlocks.registerRelay("relay_mk3", EnumRelayTier.MK3, state -> 15);

    private static BlockRegistryObject<Block, ItemFuelBlock> registerFuelBlock(String name, EnumFuelType fuelType) {
        return BLOCKS.registerDefaultProperties(name, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(0.5f, 1.5f)), (block, properties) -> new ItemFuelBlock((Block)block, (Item.Properties)properties, fuelType));
    }

    private static BlockRegistryObject<Collector, CollectorItem> registerCollector(String name, EnumCollectorTier collectorTier, ToIntFunction<BlockState> lightLevel) {
        return BLOCKS.registerDefaultProperties(name, () -> new Collector(collectorTier, AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200948_a(0.3f, 0.9f).func_235838_a_(lightLevel)), CollectorItem::new);
    }

    private static <CONDENSER extends Condenser> BlockRegistryObject<CONDENSER, BlockItem> registerCondenser(String name, Function<AbstractBlock.Properties, CONDENSER> condenserFunction, Function<CONDENSER, BlockItem> itemCreator) {
        return BLOCKS.register(name, () -> (Condenser)((Object)((Object)condenserFunction.apply(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(10.0f, 3600000.0f)))), itemCreator);
    }

    private static BlockRegistryObject<Relay, RelayItem> registerRelay(String name, EnumRelayTier relayTier, ToIntFunction<BlockState> lightLevel) {
        return BLOCKS.registerDefaultProperties(name, () -> new Relay(relayTier, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(10.0f, 30.0f).func_235838_a_(lightLevel)), RelayItem::new);
    }

    private static BlockRegistryObject<ProjectETNT, BlockItem> registerExplosive(String name, ProjectETNT.TNTEntityCreator tntEntityCreator) {
        return BLOCKS.register(name, () -> new ProjectETNT(AbstractBlock.Properties.func_200945_a((Material)Material.field_151590_u).func_200943_b(0.0f), tntEntityCreator));
    }

    private static BlockRegistryObject<MatterFurnace, BlockItem> registerFurnace(String name, EnumMatterType matterType, float hardness, float resistance) {
        return BLOCKS.register(name, () -> new MatterFurnace(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(hardness, resistance).func_235838_a_(state -> 14), matterType), block -> new BlockItem((Block)block, ItemDeferredRegister.getBaseProperties().func_234689_a_()));
    }

    private static BlockRegistryObject<MatterBlock, BlockItem> registerMatterBlock(String name, EnumMatterType matterType, float hardness, float resistance) {
        return BLOCKS.register(name, () -> new MatterBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_235861_h_().func_200948_a(hardness, resistance).func_235838_a_(state -> 14), matterType), block -> new BlockItem((Block)block, ItemDeferredRegister.getBaseProperties().func_234689_a_()));
    }
}

