/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.tools.PETool;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.ToolHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolType;

public class PEKatar
extends PETool
implements IItemMode,
IExtraFunction {
    private final ToolHelper.ChargeAttributeCache attributeCache = new ToolHelper.ChargeAttributeCache();
    private final ILangEntry[] modeDesc = new ILangEntry[]{PELang.MODE_KATAR_1, PELang.MODE_KATAR_2};

    public PEKatar(EnumMatterType matterType, int numCharges, Item.Properties props) {
        super(matterType, 19.0f, -2.4f, numCharges, props.addToolType(ToolType.AXE, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_SHEARS, matterType.func_200925_d()).addToolType(ToolType.HOE, matterType.func_200925_d()).addToolType(ToolHelper.TOOL_TYPE_KATAR, matterType.func_200925_d()));
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return this.modeDesc;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add(this.getToolTip(stack));
    }

    public boolean func_150897_b(BlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196553_aF || block == Blocks.field_150488_af || block == Blocks.field_150473_bD;
    }

    @Override
    protected float getShortCutDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        float destroySpeed = super.getShortCutDestroySpeed(stack, state);
        if (destroySpeed == 1.0f) {
            Material material = state.func_185904_a();
            if (material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_215713_z) {
                return this.field_77864_a;
            }
            if (state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_((ITag)BlockTags.field_199897_a)) {
                return this.field_77864_a;
            }
        }
        return destroySpeed;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        return ToolHelper.performActions(ToolHelper.stripLogsAOE(context, 0L), () -> ToolHelper.tillHoeAOE(context, 0L), () -> {
            if (state.func_203425_a(Blocks.field_150423_aK)) {
                if (!world.field_72995_K) {
                    Direction direction = context.func_196000_l();
                    Direction side = direction.func_176740_k() == Direction.Axis.Y ? context.func_195992_f().func_176734_d() : direction;
                    world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)side), 11);
                    ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
                    itementity.func_213293_j(0.05 * (double)side.func_82601_c() + world.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)side.func_82599_e() + world.field_73012_v.nextDouble() * 0.02);
                    world.func_217376_c((Entity)itementity);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }, () -> {
            if (state.func_235714_a_((ITag)BlockTags.field_226151_aa_) && state.func_177230_c() instanceof BeehiveBlock && (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5) {
                BeehiveBlock beehive = (BeehiveBlock)state.func_177230_c();
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
                if (!CampfireBlock.func_235474_a_((World)world, (BlockPos)pos)) {
                    if (beehive.func_226882_d_(world, pos)) {
                        beehive.func_226881_b_(world, pos);
                    }
                    beehive.func_226877_a_(world, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
                } else {
                    beehive.func_226876_a_(world, state, pos);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }, () -> {
            if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
                return ToolHelper.clearTagAOE(world, player, hand, stack, 0L, (ITag<Block>)BlockTags.field_200031_h);
            }
            return ActionResultType.PASS;
        }, () -> {
            if (state.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                return ToolHelper.clearTagAOE(world, player, hand, stack, 0L, (ITag<Block>)BlockTags.field_206952_E);
            }
            return ActionResultType.PASS;
        });
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity damaged, @Nonnull LivingEntity damager) {
        ToolHelper.attackWithCharge(stack, damaged, damager, 1.0f);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return ToolHelper.shearBlock(stack, pos, player) == ActionResultType.SUCCESS;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        if (state.func_203425_a(Blocks.field_150473_bD) && !((Boolean)state.func_177229_b((Property)TripWireBlock.field_176295_N)).booleanValue()) {
            BlockState deactivated = (BlockState)state.func_206870_a((Property)TripWireBlock.field_176295_N, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, deactivated, 4);
            return super.func_179218_a(stack, world, deactivated, pos, entity);
        }
        return super.func_179218_a(stack, world, state, pos, entity);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        return ItemHelper.actionResultFromType(ToolHelper.shearEntityAOE(player, hand, 0L), player.func_184586_b(hand));
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        if (player.func_184825_o(0.0f) == 1.0f) {
            ToolHelper.attackAOE(stack, player, this.getMode(stack) == 1, ProjectEConfig.server.difficulty.katarDeathAura.get(), 0L, hand);
            PlayerHelper.resetCooldown(player);
            return true;
        }
        return false;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, ItemStack stack) {
        return this.attributeCache.addChargeAttributeModifier((Multimap<Attribute, AttributeModifier>)super.getAttributeModifiers(slot, stack), slot, stack);
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull LivingEntity entity, @Nonnull Hand hand) {
        BlockPos pos;
        IForgeShearable target;
        if (entity instanceof IForgeShearable && (target = (IForgeShearable)entity).isShearable(stack, entity.field_70170_p, pos = entity.func_233580_cy_())) {
            if (!entity.field_70170_p.field_72995_K) {
                List drops = target.onSheared(player, stack, entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    if (ent != null) {
                        ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

