/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Zero
extends PEToggleItem
implements IPedestalItem,
IItemCharge {
    public Zero(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean held) {
        super.func_77663_a(stack, world, entity, slot, held);
        if (!world.field_72995_K && entity instanceof PlayerEntity && slot < PlayerInventory.func_70451_h() && ItemHelper.checkItemNBT(stack, "Active")) {
            AxisAlignedBB box = new AxisAlignedBB(entity.func_226277_ct_() - 3.0, entity.func_226278_cu_() - 3.0, entity.func_226281_cx_() - 3.0, entity.func_226277_ct_() + 3.0, entity.func_226278_cu_() + 3.0, entity.func_226281_cx_() + 3.0);
            WorldHelper.freezeInBoundingBox(world, box, (PlayerEntity)entity, true);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int offset = 3 + this.getCharge(stack);
            AxisAlignedBB box = player.func_174813_aQ().func_186662_g((double)offset);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.POWER.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            WorldHelper.freezeInBoundingBox(world, box, player, false);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.zero.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                AxisAlignedBB aabb = tile.getEffectBounds();
                WorldHelper.freezeInBoundingBox(world, aabb, null, false);
                List list = world.func_217357_a(Entity.class, aabb);
                for (Entity ent : list) {
                    if (!ent.func_70027_ad()) continue;
                    ent.func_70066_B();
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.zero.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.zero.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_ZERO_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_ZERO_2.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_ZERO_3.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.zero.get())));
        }
        return list;
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 4;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }
}

