/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MindStone
extends PEToggleItem
implements IPedestalItem {
    private static final int TRANSFER_RATE = 50;

    public MindStone(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot >= PlayerInventory.func_70451_h() || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        if (ItemHelper.checkItemNBT(stack, "Active") && this.getXP(player) > 0) {
            int toAdd = Math.min(this.getXP(player), 50);
            this.addStoredXP(stack, toAdd);
            this.removeXP(player, 50);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        int toAdd;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !stack.func_196082_o().func_74767_n("Active") && this.getStoredXP(stack) != 0 && (toAdd = this.removeStoredXP(stack, 50)) > 0) {
            this.addXP(player, toAdd);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        if (stack.func_77942_o()) {
            tooltips.add((ITextComponent)PELang.TOOLTIP_STORED_XP.translateColored(TextFormatting.DARK_GREEN, TextFormatting.GREEN, String.format("%,d", this.getStoredXP(stack))));
        }
    }

    private void removeXP(PlayerEntity player, int amount) {
        int totalExperience = this.getXP(player) - amount;
        if (totalExperience < 0) {
            player.field_71067_cb = 0;
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
        } else {
            player.field_71067_cb = totalExperience;
            player.field_71068_ca = this.getLvlForXP(totalExperience);
            player.field_71106_cc = (float)(totalExperience - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
        }
    }

    private void addXP(PlayerEntity player, int amount) {
        int experiencetotal;
        player.field_71067_cb = experiencetotal = this.getXP(player) + amount;
        player.field_71068_ca = this.getLvlForXP(experiencetotal);
        player.field_71106_cc = (float)(experiencetotal - this.getXPForLvl(player.field_71068_ca)) / (float)player.func_71050_bK();
    }

    private int getXP(PlayerEntity player) {
        return (int)((float)this.getXPForLvl(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int getXPForLvl(int level) {
        if (level < 0) {
            return Integer.MAX_VALUE;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
        }
        return (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
    }

    private int getLvlForXP(int totalXP) {
        int result = 0;
        while (this.getXPForLvl(result) <= totalXP) {
            ++result;
        }
        return --result;
    }

    private int getStoredXP(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74762_e("StoredXP") : 0;
    }

    private void setStoredXP(ItemStack stack, int XP) {
        stack.func_196082_o().func_74768_a("StoredXP", XP);
    }

    private void addStoredXP(ItemStack stack, int XP) {
        long result = (long)this.getStoredXP(stack) + (long)XP;
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        this.setStoredXP(stack, (int)result);
    }

    private int removeStoredXP(ItemStack stack, int XP) {
        int returnResult;
        int result;
        int currentXP = this.getStoredXP(stack);
        if (currentXP < XP) {
            result = 0;
            returnResult = currentXP;
        } else {
            result = currentXP - XP;
            returnResult = XP;
        }
        this.setStoredXP(stack, result);
        return returnResult;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true);
        if (tile != null) {
            List orbs = world.func_217357_a(ExperienceOrbEntity.class, tile.getEffectBounds());
            for (ExperienceOrbEntity orb : orbs) {
                WorldHelper.gravitateEntityTowards((Entity)orb, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                if (world.field_72995_K || !(orb.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < 1.21)) continue;
                this.suckXP(orb, tile.getInventory().getStackInSlot(0));
            }
        }
    }

    private void suckXP(ExperienceOrbEntity orb, ItemStack mindStone) {
        long l = this.getStoredXP(mindStone);
        if (l + (long)orb.field_70530_e > Integer.MAX_VALUE) {
            orb.field_70530_e = (int)(l + (long)orb.field_70530_e - Integer.MAX_VALUE);
            this.setStoredXP(mindStone, Integer.MAX_VALUE);
        } else {
            this.addStoredXP(mindStone, orb.field_70530_e);
            orb.func_70106_y();
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        return Lists.newArrayList((Object[])new ITextComponent[]{PELang.PEDESTAL_MIND_STONE.translateColored(TextFormatting.BLUE, new Object[0])});
    }
}

