/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GemChest
extends GemArmorBase
implements IFireProtector {
    public GemChest(Item.Properties props) {
        super(EquipmentSlotType.CHEST, props);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.GEM_LORE_CHEST.translate(new Object[0]));
    }

    public void onArmorTick(ItemStack chest, World world, PlayerEntity player) {
        if (!world.field_72995_K) {
            player.getCapability(InternalTimers.CAPABILITY).ifPresent(timers -> {
                timers.activateFeed();
                if (player.func_71024_bL().func_75121_c() && timers.canFeed()) {
                    player.func_71024_bL().func_75122_a(2, 10.0f);
                }
            });
        }
    }

    public void doExplode(PlayerEntity player) {
        if (ProjectEConfig.server.difficulty.offensiveAbilities.get()) {
            WorldHelper.createNovaExplosion(player.func_130014_f_(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 9.0f);
        }
    }

    @Override
    public boolean canProtectAgainstFire(ItemStack stack, ServerPlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.CHEST) == stack;
    }
}

