/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.ProjectileShooterItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.container.PhilosStoneContainer;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone(Item.Properties props) {
        super(props, 4, PELang.MODE_PHILOSOPHER_1, PELang.MODE_PHILOSOPHER_2, PELang.MODE_PHILOSOPHER_3);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(ProjectileShooterItemCapabilityWrapper::new);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public BlockRayTraceResult getHitBlock(PlayerEntity player) {
        return PhilosophersStone.func_219968_a((World)player.func_130014_f_(), (PlayerEntity)player, (RayTraceContext.FluidMode)(player.func_225608_bj_() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        Map<BlockPos, BlockState> toChange;
        PlayerEntity player = ctx.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        BlockPos pos = ctx.func_195995_a();
        Direction sideHit = ctx.func_196000_l();
        World world = ctx.func_195991_k();
        ItemStack stack = ctx.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockRayTraceResult rtr = this.getHitBlock(player);
        if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK && !rtr.func_216350_a().equals((Object)pos)) {
            pos = rtr.func_216350_a();
            sideHit = rtr.func_216354_b();
        }
        if (!(toChange = PhilosophersStone.getChanges(world, pos, player, sideHit, this.getMode(stack), this.getCharge(stack))).isEmpty()) {
            for (Map.Entry<BlockPos, BlockState> entry : toChange.entrySet()) {
                BlockPos currentPos = entry.getKey();
                PlayerHelper.checkedReplaceBlock((ServerPlayerEntity)player, currentPos, entry.getValue());
                if (world.field_73012_v.nextInt(8) != 0) continue;
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, Hand hand) {
        World world = player.func_130014_f_();
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.TRANSMUTE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityMobRandomizer ent = new EntityMobRandomizer(player, world);
        ent.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_217376_c((Entity)ent);
        return true;
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        if (!player.func_130014_f_().field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(stack));
        }
        return true;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.TOOLTIP_PHILOSTONE.translate(ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)));
    }

    public static Map<BlockPos, BlockState> getChanges(World world, BlockPos pos, PlayerEntity player, Direction sideHit, int mode, int charge) {
        boolean isSneaking;
        BlockState targeted = world.func_180495_p(pos);
        BlockState result = WorldTransmutations.getWorldTransmutation(targeted, isSneaking = player.func_225608_bj_());
        if (result == null) {
            return Collections.emptyMap();
        }
        Stream stream = null;
        switch (mode) {
            case 0: {
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, -charge, -charge), (BlockPos)pos.func_177982_a(charge, charge, charge));
                break;
            }
            case 1: {
                if (sideHit == Direction.UP || sideHit == Direction.DOWN) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, 0, -charge), (BlockPos)pos.func_177982_a(charge, 0, charge));
                    break;
                }
                if (sideHit == Direction.EAST || sideHit == Direction.WEST) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, -charge, -charge), (BlockPos)pos.func_177982_a(0, charge, charge));
                    break;
                }
                if (sideHit != Direction.SOUTH && sideHit != Direction.NORTH) break;
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, -charge, 0), (BlockPos)pos.func_177982_a(charge, charge, 0));
                break;
            }
            case 2: {
                Direction playerFacing = player.func_174811_aO();
                if (playerFacing.func_176740_k() == Direction.Axis.Z) {
                    stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(0, 0, -charge), (BlockPos)pos.func_177982_a(0, 0, charge));
                    break;
                }
                if (playerFacing.func_176740_k() != Direction.Axis.X) break;
                stream = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-charge, 0, 0), (BlockPos)pos.func_177982_a(charge, 0, 0));
            }
        }
        if (stream == null) {
            return Collections.emptyMap();
        }
        Object2ObjectArrayMap conversions = new Object2ObjectArrayMap();
        conversions.put(targeted, result);
        HashMap<BlockPos, BlockState> changes = new HashMap<BlockPos, BlockState>();
        Block targetBlock = targeted.func_177230_c();
        stream.forEach(arg_0 -> PhilosophersStone.lambda$getChanges$0(world, targetBlock, (Map)conversions, isSneaking, changes, arg_0));
        return changes;
    }

    private static /* synthetic */ void lambda$getChanges$0(World world, Block targetBlock, Map conversions, boolean isSneaking, Map changes, BlockPos currentPos) {
        BlockState state = world.func_180495_p(currentPos);
        if (state.func_203425_a(targetBlock)) {
            BlockState actualResult;
            if (conversions.containsKey(state)) {
                actualResult = (BlockState)conversions.get(state);
            } else {
                actualResult = WorldTransmutations.getWorldTransmutation(state, isSneaking);
                conversions.put(state, actualResult);
            }
            if (actualResult != null) {
                changes.put(currentPos.func_185334_h(), actualResult);
            }
        }
    }

    private static class ContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public Container createMenu(int windowId, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerIn) {
            return new PhilosStoneContainer(windowId, playerInventory, IWorldPosCallable.func_221488_a((World)playerIn.func_130014_f_(), (BlockPos)playerIn.func_233580_cy_()));
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.stack.func_200301_q();
        }
    }
}

