/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.IItemCapabilitySerializable;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.gameObjs.container.MercurialEyeContainer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private static final int CREATION_MODE = 0;
    private static final int EXTENSION_MODE = 1;
    private static final int EXTENSION_MODE_CLASSIC = 2;
    private static final int TRANSMUTATION_MODE = 3;
    private static final int TRANSMUTATION_MODE_CLASSIC = 4;
    private static final int PILLAR_MODE = 5;

    public MercurialEye(Item.Properties props) {
        super(props, 4, PELang.MODE_MERCURIAL_EYE_1, PELang.MODE_MERCURIAL_EYE_2, PELang.MODE_MERCURIAL_EYE_3, PELang.MODE_MERCURIAL_EYE_4, PELang.MODE_MERCURIAL_EYE_5, PELang.MODE_MERCURIAL_EYE_6);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(() -> new EyeInventoryHandler());
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        int selected = player.field_71071_by.field_70461_c;
        SimpleNamedContainerProvider provider = new SimpleNamedContainerProvider((id, inv, pl) -> new MercurialEyeContainer(id, inv, hand, selected), stack.func_200301_q());
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, b -> {
            b.func_179249_a((Enum)hand);
            b.writeByte(selected);
        });
        return true;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        return ctx.func_195991_k().field_72995_K ? ActionResultType.SUCCESS : this.formBlocks(stack, ctx.func_195999_j(), ctx.func_195995_a(), ctx.func_196000_l());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getMode(stack) == 0) {
            if (world.field_72995_K) {
                return ActionResult.func_226248_a_((Object)stack);
            }
            Vector3d eyeVec = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
            Vector3d lookVec = player.func_70040_Z();
            Vector3d targVec = eyeVec.func_72441_c(lookVec.field_72450_a * 2.0, lookVec.field_72448_b * 2.0, lookVec.field_72449_c * 2.0);
            return ItemHelper.actionResultFromType(this.formBlocks(stack, player, new BlockPos(targVec), null), stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    private ActionResultType formBlocks(ItemStack eye, PlayerEntity player, BlockPos startingPos, @Nullable Direction facing) {
        long newBlockEmc;
        BlockState newState;
        Optional inventoryCapability = eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!inventoryCapability.isPresent()) {
            return ActionResultType.FAIL;
        }
        IItemHandler inventory = (IItemHandler)inventoryCapability.get();
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.func_190926_b() || !klein.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.FAIL;
        }
        World world = player.func_130014_f_();
        BlockState startingState = world.func_180495_p(startingPos);
        long startingBlockEmc = EMCHelper.getEmcValue(new ItemStack((IItemProvider)startingState.func_177230_c()));
        ItemStack target = inventory.getStackInSlot(1);
        byte mode = this.getMode(eye);
        if (!target.func_190926_b()) {
            newState = ItemHelper.stackToState(target);
            newBlockEmc = EMCHelper.getEmcValue(target);
        } else if (startingBlockEmc != 0L && (mode == 1 || mode == 2)) {
            newState = startingState;
            newBlockEmc = startingBlockEmc;
        } else {
            return ActionResultType.FAIL;
        }
        if (newState == null || newState.func_177230_c().isAir(newState, null, null)) {
            return ActionResultType.FAIL;
        }
        NonNullList drops = NonNullList.func_191196_a();
        int charge = this.getCharge(eye);
        int hitTargets = 0;
        if (mode == 0) {
            Block block = startingState.func_177230_c();
            if (facing != null && (!startingState.func_185904_a().func_76222_j() || player.func_225608_bj_() && !block.isAir(startingState, (IBlockReader)world, startingPos))) {
                BlockPos offsetPos = startingPos.func_177972_a(facing);
                BlockState offsetState = world.func_180495_p(offsetPos);
                if (!offsetState.func_185904_a().func_76222_j()) {
                    return ActionResultType.FAIL;
                }
                long offsetBlockEmc = EMCHelper.getEmcValue(new ItemStack((IItemProvider)offsetState.func_177230_c()));
                if (this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                    ++hitTargets;
                }
            } else if (this.doBlockPlace(player, startingState, startingPos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                ++hitTargets;
            }
        } else if (mode == 5) {
            hitTargets += this.fillGaps(eye, player, world, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, 1, 3 * charge + 2), (NonNullList<ItemStack>)drops);
        } else if (mode == 2) {
            hitTargets += this.fillGaps(eye, player, world, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, charge, 0), (NonNullList<ItemStack>)drops);
        } else if (mode == 4) {
            Pair<BlockPos, BlockPos> corners = this.getCorners(startingPos, facing, charge, 0);
            for (BlockPos pos : WorldHelper.getPositionsFromBox(new AxisAlignedBB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
                BlockState placedState = world.func_180495_p(pos);
                if (placedState != startingState || !this.doBlockPlace(player, placedState, pos.func_185334_h(), newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) continue;
                ++hitTargets;
            }
        } else {
            if (startingState.func_177230_c().isAir(startingState, (IBlockReader)world, startingPos) || facing == null) {
                return ActionResultType.FAIL;
            }
            LinkedList<BlockPos> possibleBlocks = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            possibleBlocks.add(startingPos);
            visited.add(startingPos);
            int side = 2 * charge + 1;
            int size = side * side;
            int totalTries = size * 4;
            for (int attemptedTargets = 0; attemptedTargets < totalTries && !possibleBlocks.isEmpty(); ++attemptedTargets) {
                BlockPos offsetPos;
                BlockState offsetState;
                BlockPos pos = (BlockPos)possibleBlocks.poll();
                BlockState checkState = world.func_180495_p(pos);
                if (startingState != checkState || (offsetState = world.func_180495_p(offsetPos = pos.func_177972_a(facing))).func_224755_d((IBlockReader)world, offsetPos, facing)) continue;
                boolean hit = false;
                if (mode == 1) {
                    VoxelShape cbBox = startingState.func_196952_d((IBlockReader)world, offsetPos);
                    if (world.func_195585_a(null, cbBox)) {
                        long offsetBlockEmc = EMCHelper.getEmcValue((IItemProvider)offsetState.func_177230_c());
                        hit = this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                    }
                } else if (mode == 3) {
                    hit = this.doBlockPlace(player, checkState, pos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                }
                if (!hit) continue;
                if (++hitTargets < size) {
                    for (Direction e : Direction.values()) {
                        BlockPos offsetOpposite;
                        if (facing.func_176740_k() == e.func_176740_k()) continue;
                        BlockPos offset = pos.func_177972_a(e);
                        if (visited.add(offset)) {
                            possibleBlocks.offer(offset);
                        }
                        if (!visited.add(offsetOpposite = pos.func_177972_a(e.func_176734_d()))) continue;
                        possibleBlocks.offer(offsetOpposite);
                    }
                    continue;
                }
                break;
            }
        }
        if (hitTargets > 0) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.POWER.get(), SoundCategory.PLAYERS, 0.8f, 2.0f / ((float)charge / (float)this.getNumCharges(eye) + 2.0f));
            if (!drops.isEmpty()) {
                WorldHelper.createLootDrop((List<ItemStack>)drops, player.func_130014_f_(), startingPos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private boolean doBlockPlace(PlayerEntity player, BlockState oldState, BlockPos placePos, BlockState newState, ItemStack eye, long oldEMC, long newEMC, NonNullList<ItemStack> drops) {
        Optional inventoryCapability = eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!inventoryCapability.isPresent()) {
            return false;
        }
        IItemHandler inventory = (IItemHandler)inventoryCapability.get();
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.func_190926_b()) {
            return false;
        }
        Optional holderCapability = klein.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (!holderCapability.isPresent() || oldState == newState || ItemPE.getEmc(klein) < newEMC - oldEMC || WorldHelper.getTileEntity((IBlockReader)player.func_130014_f_(), placePos) != null) {
            return false;
        }
        if (oldEMC == 0L && oldState.func_185887_b((IBlockReader)player.field_70170_p, placePos) == -1.0f) {
            return false;
        }
        if (PlayerHelper.checkedReplaceBlock((ServerPlayerEntity)player, placePos, newState)) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            if (oldEMC == 0L) {
                drops.addAll((Collection)Block.func_220070_a((BlockState)oldState, (ServerWorld)((ServerPlayerEntity)player).func_71121_q(), (BlockPos)placePos, null));
                emcHolder.extractEmc(klein, newEMC, IEmcStorage.EmcAction.EXECUTE);
            } else if (oldEMC > newEMC) {
                emcHolder.insertEmc(klein, oldEMC - newEMC, IEmcStorage.EmcAction.EXECUTE);
            } else if (oldEMC < newEMC) {
                emcHolder.extractEmc(klein, newEMC - oldEMC, IEmcStorage.EmcAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    private int fillGaps(ItemStack eye, PlayerEntity player, World world, BlockState startingState, BlockState newState, long newBlockEmc, Pair<BlockPos, BlockPos> corners, NonNullList<ItemStack> drops) {
        int hitTargets = 0;
        for (BlockPos pos : WorldHelper.getPositionsFromBox(new AxisAlignedBB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
            BlockState placeState;
            VoxelShape bb = startingState.func_196952_d((IBlockReader)world, pos);
            if (!world.func_195585_a(null, bb) || !(placeState = world.func_180495_p(pos)).func_185904_a().func_76222_j()) continue;
            long placeBlockEmc = EMCHelper.getEmcValue((IItemProvider)placeState.func_177230_c());
            if (!this.doBlockPlace(player, placeState, pos.func_185334_h(), newState, eye, placeBlockEmc, newBlockEmc, drops)) continue;
            ++hitTargets;
        }
        return hitTargets;
    }

    private Pair<BlockPos, BlockPos> getCorners(BlockPos startingPos, Direction facing, int strength, int depth) {
        if (facing == null) {
            return new ImmutablePair((Object)startingPos, (Object)startingPos);
        }
        BlockPos start = startingPos;
        BlockPos end = startingPos;
        switch (facing) {
            case UP: {
                start = start.func_177982_a(-strength, -depth, -strength);
                end = end.func_177982_a(strength, 0, strength);
                break;
            }
            case DOWN: {
                start = start.func_177982_a(-strength, 0, -strength);
                end = end.func_177982_a(strength, depth, strength);
                break;
            }
            case SOUTH: {
                start = start.func_177982_a(-strength, -strength, -depth);
                end = end.func_177982_a(strength, strength, 0);
                break;
            }
            case NORTH: {
                start = start.func_177982_a(-strength, -strength, 0);
                end = end.func_177982_a(strength, strength, depth);
                break;
            }
            case EAST: {
                start = start.func_177982_a(-depth, -strength, -strength);
                end = end.func_177982_a(0, strength, strength);
                break;
            }
            case WEST: {
                start = start.func_177982_a(0, -strength, -strength);
                end = end.func_177982_a(depth, strength, strength);
            }
        }
        return new ImmutablePair((Object)start, (Object)end);
    }

    private static class EyeInventoryHandler
    extends ItemCapability<IItemHandler>
    implements IItemCapabilitySerializable {
        private final IItemHandler inv = new ItemStackHandler(2);
        private final LazyOptional<IItemHandler> invInst = LazyOptional.of(() -> this.inv);

        private EyeInventoryHandler() {
        }

        public INBT serializeNBT() {
            return this.getCapability().writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(INBT nbt) {
            this.getCapability().readNBT((Object)this.inv, null, nbt);
        }

        @Override
        public Capability<IItemHandler> getCapability() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Override
        public LazyOptional<IItemHandler> getLazyCapability() {
            return this.invInst;
        }

        @Override
        public String getStorageKey() {
            return "EyeInventory";
        }
    }
}

