/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.text.ILangEntry;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class ItemMode
extends ItemPE
implements IItemMode,
IItemCharge {
    private final int numCharge;
    private final ILangEntry[] modes;

    public ItemMode(Item.Properties props, int numCharge, ILangEntry ... modeDescrp) {
        super(props);
        this.numCharge = numCharge;
        this.modes = modeDescrp;
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return this.modes;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add(this.getToolTip(stack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return this.numCharge;
    }
}

