/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.items.PhilosophersStone;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PhiloStoneSmeltingRecipe
extends SpecialRecipe {
    public PhiloStoneSmeltingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return !this.getMatchingRecipes(inv, world).isEmpty();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        Set<FurnaceRecipe> matchingRecipes = this.getMatchingRecipes(inv, (World)ServerLifecycleHooks.getCurrentServer().func_241755_D_());
        if (matchingRecipes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack output = ((FurnaceRecipe)matchingRecipes.stream().findFirst().get()).func_77571_b().func_77946_l();
        output.func_190920_e(output.func_190916_E() * 7);
        return output;
    }

    private Set<FurnaceRecipe> getMatchingRecipes(CraftingInventory inv, @Nonnull World world) {
        ArrayList<ItemStack> philoStones = new ArrayList<ItemStack>();
        ArrayList<ItemStack> coals = new ArrayList<ItemStack>();
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            allItems.add(stack);
            if (allItems.size() > 9) {
                return Collections.emptySet();
            }
            if (item instanceof PhilosophersStone) {
                philoStones.add(stack);
            }
            if (!item.func_206844_a((ITag)ItemTags.field_219775_L)) continue;
            coals.add(stack);
        }
        if (allItems.size() == 9) {
            for (ItemStack philoStone : philoStones) {
                for (ItemStack coal : coals) {
                    if (philoStone == coal) continue;
                    HashSet<FurnaceRecipe> matchingRecipes = new HashSet<FurnaceRecipe>();
                    for (ItemStack stack : allItems) {
                        if (stack == philoStone || stack == coal) continue;
                        Inventory furnaceInput = new Inventory(new ItemStack[]{stack});
                        if (!(matchingRecipes.isEmpty() ? !matchingRecipes.addAll(world.func_199532_z().func_215370_b(IRecipeType.field_222150_b, (IInventory)furnaceInput, world)) : matchingRecipes.removeIf(recipe -> !recipe.func_77569_a((IInventory)furnaceInput, world)) && matchingRecipes.isEmpty())) continue;
                        return Collections.emptySet();
                    }
                    if (matchingRecipes.isEmpty()) continue;
                    return matchingRecipes;
                }
            }
        }
        return Collections.emptySet();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 9;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)PERecipeSerializers.PHILO_STONE_SMELTING.get();
    }
}

