/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.customRecipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.Constants;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class FullKleinStarIngredient
extends Ingredient {
    public static final IIngredientSerializer<FullKleinStarIngredient> SERIALIZER = new IIngredientSerializer<FullKleinStarIngredient>(){

        @Nonnull
        public FullKleinStarIngredient parse(@Nonnull PacketBuffer buffer) {
            return new FullKleinStarIngredient((KleinStar.EnumKleinTier)buffer.func_179257_a(KleinStar.EnumKleinTier.class));
        }

        @Nonnull
        public FullKleinStarIngredient parse(@Nonnull JsonObject json) {
            int tier = JSONUtils.func_151203_m((JsonObject)json, (String)"tier");
            KleinStar.EnumKleinTier[] tiers = KleinStar.EnumKleinTier.values();
            if (tier < 0 || tier >= tiers.length) {
                throw new JsonParseException("Invalid klein star tier");
            }
            return new FullKleinStarIngredient(tiers[tier]);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull FullKleinStarIngredient ingredient) {
            buffer.func_179249_a((Enum)((KleinStar)((FullKleinStarIngredient)ingredient).star.func_77973_b()).tier);
        }
    };
    private final ItemStack star;

    private static ItemStack getFullStar(KleinStar.EnumKleinTier tier) {
        ItemStack star = new ItemStack((IItemProvider)PEItems.getStar(tier));
        ItemPE.setEmc(star, Constants.MAX_KLEIN_EMC[tier.ordinal()]);
        return star;
    }

    public FullKleinStarIngredient(KleinStar.EnumKleinTier tier) {
        this(FullKleinStarIngredient.getFullStar(tier));
    }

    private FullKleinStarIngredient(ItemStack star) {
        super(Stream.of(new Ingredient.SingleItemList(star)));
        this.star = star;
    }

    public boolean test(@Nullable ItemStack input) {
        return input != null && !input.func_190926_b() && ItemStack.func_77989_b((ItemStack)input, (ItemStack)this.star);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(SERIALIZER).toString());
        json.addProperty("tier", (Number)((KleinStar)this.star.func_77973_b()).tier.ordinal());
        return json;
    }
}

