/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.container.slots.HotBarSlot;
import moze_intel.projecte.gameObjs.container.slots.IInsertableSlot;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.MainInventorySlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;

public abstract class PEContainer
extends Container {
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    private final List<IntReferenceHolder> intFields = new ArrayList<IntReferenceHolder>();
    protected final List<BoxedLong> longFields = new ArrayList<BoxedLong>();

    protected PEContainer(ContainerTypeRegistryObject<? extends PEContainer> typeRO, int id) {
        super((ContainerType)typeRO.get(), id);
    }

    protected void addPlayerInventory(PlayerInventory invPlayer, int xStart, int yStart) {
        int i;
        int slotSize = 18;
        int rows = 3;
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(this.createMainInventorySlot(invPlayer, j + i * 9 + 9, xStart + j * slotSize, yStart + i * slotSize));
            }
        }
        yStart = yStart + slotSize * rows + 4;
        for (i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            this.func_75146_a(this.createHotBarSlot(invPlayer, i, xStart + i * slotSize, yStart));
        }
    }

    protected MainInventorySlot createMainInventorySlot(@Nonnull PlayerInventory inv, int index, int x, int y) {
        return new MainInventorySlot((IInventory)inv, index, x, y);
    }

    protected HotBarSlot createHotBarSlot(@Nonnull PlayerInventory inv, int index, int x, int y) {
        return new HotBarSlot((IInventory)inv, index, x, y);
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slot) {
        super.func_75146_a(slot);
        if (slot instanceof InventoryContainerSlot) {
            this.inventoryContainerSlots.add((InventoryContainerSlot)slot);
        } else if (slot instanceof MainInventorySlot) {
            this.mainInventorySlots.add((MainInventorySlot)slot);
        } else if (slot instanceof HotBarSlot) {
            this.hotBarSlots.add((HotBarSlot)slot);
        }
        return slot;
    }

    @Nullable
    public Slot tryGetSlot(int slotId) {
        if (slotId >= 0 && slotId < this.field_75151_b.size()) {
            return this.func_75139_a(slotId);
        }
        return null;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotID) {
        ItemStack slotStack;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot == null || !currentSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackToInsert = slotStack = currentSlot.func_75211_c();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
        } else {
            stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots, stackToInsert, true);
            if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots, stackToInsert, false);
                if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                    if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
                    }
                }
            }
        }
        if (stackToInsert.func_190916_E() == slotStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        int difference = slotStack.func_190916_E() - stackToInsert.func_190916_E();
        currentSlot.func_75209_a(difference);
        ItemStack newStack = ItemHelper.size(slotStack, difference);
        currentSlot.func_190901_a(player, newStack);
        return newStack;
    }

    @Nonnull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty) {
        Slot slot;
        if (stack.func_190926_b()) {
            return stack;
        }
        Iterator<SLOT> iterator = slots.iterator();
        while (iterator.hasNext() && (ignoreEmpty != (slot = (Slot)iterator.next()).func_75216_d() || !(stack = ((IInsertableSlot)slot).insertItem(stack, false)).func_190926_b())) {
        }
        return stack;
    }

    protected static boolean stillValid(PlayerEntity player, TileEntity tile, BlockRegistryObject<?, ?> blockRO) {
        BlockPos pos = tile.func_174877_v();
        return player.field_70170_p.func_180495_p(pos).func_177230_c() == blockRO.getBlock() && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public final void updateProgressBarLong(int idx, long data) {
        this.longFields.get(idx).set(data);
    }

    public final void updateProgressBarInt(int idx, int data) {
        this.intFields.get(idx).func_221494_a(data);
    }

    @Nonnull
    protected IntReferenceHolder func_216958_a(@Nonnull IntReferenceHolder referenceHolder) {
        this.intFields.add(referenceHolder);
        return referenceHolder;
    }

    public void func_75142_b() {
        int i;
        for (i = 0; i < this.longFields.size(); ++i) {
            BoxedLong boxedLong = this.longFields.get(i);
            if (!boxedLong.isDirty()) continue;
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateLong(listener, this, i, boxedLong.get());
            }
        }
        for (i = 0; i < this.intFields.size(); ++i) {
            IntReferenceHolder referenceHolder = this.intFields.get(i);
            if (!referenceHolder.func_221496_c()) continue;
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendProgressBarUpdateInt(listener, this, i, referenceHolder.func_221495_b());
            }
        }
        super.func_75142_b();
    }

    public static class BoxedLong {
        private long inner;
        private boolean dirty = false;

        public long get() {
            return this.inner;
        }

        public void set(long v) {
            if (v != this.inner) {
                this.inner = v;
                this.dirty = true;
            }
        }

        public boolean isDirty() {
            boolean ret = this.dirty;
            this.dirty = false;
            return ret;
        }
    }
}

