/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MercurialEyeContainer
extends PEHandContainer {
    private final SlotGhost mercurialTarget;

    public static MercurialEyeContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        return new MercurialEyeContainer(windowId, invPlayer, (Hand)buf.func_179257_a(Hand.class), (int)buf.readByte());
    }

    public MercurialEyeContainer(int windowId, PlayerInventory invPlayer, Hand hand, int selected) {
        super(PEContainerTypes.MERCURIAL_EYE_CONTAINER, windowId, hand, selected);
        IItemHandler handler = (IItemHandler)this.getStack(invPlayer).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
        this.func_75146_a((Slot)new ValidatedSlot(handler, 0, 50, 26, SlotPredicates.EMC_HOLDER));
        this.mercurialTarget = new SlotGhost(handler, 1, 104, 26, SlotPredicates.MERCURIAL_TARGET);
        this.func_75146_a((Slot)this.mercurialTarget);
        this.addPlayerInventory(invPlayer, 6, 56);
    }

    @Override
    @Nonnull
    public ItemStack clickPostValidate(int slotId, int button, @Nonnull ClickType flag, @Nonnull PlayerEntity player) {
        Slot slot = this.tryGetSlot(slotId);
        if (slot instanceof SlotGhost && !slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        return super.clickPostValidate(slotId, button, flag, player);
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotID) {
        if (slotID > 1 && !this.mercurialTarget.func_75216_d()) {
            Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
            if (currentSlot == null || !currentSlot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slotStack = currentSlot.func_75211_c();
            if (!slotStack.func_190926_b() && this.mercurialTarget.isValid(slotStack)) {
                this.mercurialTarget.func_75215_d(slotStack);
                return ItemStack.field_190927_a;
            }
        }
        return super.func_82846_b(player, slotID);
    }
}

