/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.MatterFurnaceOutputSlot;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;

public class DMFurnaceContainer
extends PEContainer {
    public final DMFurnaceTile tile;

    protected DMFurnaceContainer(ContainerTypeRegistryObject<? extends DMFurnaceContainer> type, int windowId, PlayerInventory invPlayer, DMFurnaceTile tile) {
        super(type, windowId);
        this.tile = tile;
        this.initSlots(invPlayer);
        this.addDataSlot(() -> this.tile.furnaceCookTime, value -> {
            this.tile.furnaceCookTime = value;
        });
        this.addDataSlot(() -> this.tile.furnaceBurnTime, value -> {
            this.tile.furnaceBurnTime = value;
        });
        this.addDataSlot(() -> this.tile.currentItemBurnTime, value -> {
            this.tile.currentItemBurnTime = value;
        });
    }

    private void addDataSlot(final IntSupplier getter, final IntConsumer setter) {
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return getter.getAsInt();
            }

            public void func_221494_a(int value) {
                setter.accept(value);
            }
        });
    }

    public DMFurnaceContainer(int windowId, PlayerInventory invPlayer, DMFurnaceTile tile) {
        this(PEContainerTypes.DM_FURNACE_CONTAINER, windowId, invPlayer, tile);
    }

    void initSlots(PlayerInventory invPlayer) {
        int j;
        int i;
        IItemHandler fuel = this.tile.getFuel();
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(fuel, 0, 49, 53, SlotPredicates.FURNACE_FUEL));
        Predicate<ItemStack> inputPredicate = stack -> !this.tile.getSmeltingResult((ItemStack)stack).func_190926_b();
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 49, 17, inputPredicate));
        int counter = 1;
        for (i = 1; i >= 0; --i) {
            for (j = 3; j >= 0; --j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter++, 13 + i * 18, 8 + j * 18, inputPredicate));
            }
        }
        counter = output.getSlots() - 1;
        this.func_75146_a((Slot)new MatterFurnaceOutputSlot(invPlayer.field_70458_d, output, counter--, 109, 35));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new MatterFurnaceOutputSlot(invPlayer.field_70458_d, output, counter--, 131 + i * 18, 8 + j * 18));
            }
        }
        this.addPlayerInventory(invPlayer, 8, 84);
    }

    protected BlockRegistryObject<MatterFurnace, ?> getValidBlock() {
        return PEBlocks.DARK_MATTER_FURNACE;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return DMFurnaceContainer.stillValid(player, this.tile, this.getValidBlock());
    }
}

