/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.gameObjs.blocks.Condenser;
import moze_intel.projecte.gameObjs.container.ChestTileEmcContainer;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotCondenserLock;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.network.PacketHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserContainer
extends ChestTileEmcContainer<CondenserTile> {
    public final PEContainer.BoxedLong displayEmc = new PEContainer.BoxedLong();
    public final PEContainer.BoxedLong requiredEmc = new PEContainer.BoxedLong();
    @Nullable
    private ItemInfo lastLockInfo;

    public CondenserContainer(int windowId, PlayerInventory invPlayer, CondenserTile condenser) {
        this(PEContainerTypes.CONDENSER_CONTAINER, windowId, invPlayer, condenser);
    }

    protected CondenserContainer(ContainerTypeRegistryObject<? extends CondenserContainer> type, int windowId, PlayerInventory invPlayer, CondenserTile condenser) {
        super(type, windowId, condenser);
        this.longFields.add(this.displayEmc);
        this.longFields.add(this.requiredEmc);
        this.initSlots(invPlayer);
    }

    protected void initSlots(PlayerInventory invPlayer) {
        this.func_75146_a(new SlotCondenserLock(((CondenserTile)this.tile)::getLockInfo, 0, 12, 6));
        Predicate<ItemStack> validator = s -> SlotPredicates.HAS_EMC.test((ItemStack)s) && !((CondenserTile)this.tile).isStackEqualToLock((ItemStack)s);
        ItemStackHandler handler = ((CondenserTile)this.tile).getInput();
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot((IItemHandler)handler, j + i * 13, 12 + j * 18, 26 + i * 18, validator));
            }
        }
        this.addPlayerInventory(invPlayer, 48, 154);
    }

    @Override
    public void func_75142_b() {
        this.displayEmc.set(((CondenserTile)this.tile).displayEmc);
        this.requiredEmc.set(((CondenserTile)this.tile).requiredEmc);
        ItemInfo lockInfo = ((CondenserTile)this.tile).getLockInfo();
        if (!Objects.equals(lockInfo, this.lastLockInfo)) {
            this.lastLockInfo = lockInfo;
            for (IContainerListener listener : this.field_75149_d) {
                PacketHandler.sendLockSlotUpdate(listener, this, lockInfo);
            }
        }
        super.func_75142_b();
    }

    protected BlockRegistryObject<? extends Condenser, ?> getValidBlock() {
        return PEBlocks.CONDENSER;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return CondenserContainer.stillValid(player, this.tile, this.getValidBlock());
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int button, @Nonnull ClickType flag, @Nonnull PlayerEntity player) {
        if (slot == 0) {
            if (((CondenserTile)this.tile).attemptCondenserSet(player)) {
                this.func_75142_b();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, button, flag, player);
    }

    public int getProgressScaled() {
        if (this.requiredEmc.get() == 0L) {
            return 0;
        }
        if (this.displayEmc.get() >= this.requiredEmc.get()) {
            return 102;
        }
        return (int)(102.0 * ((double)this.displayEmc.get() / (double)this.requiredEmc.get()));
    }

    public void updateLockInfo(@Nullable ItemInfo lockInfo) {
        ((CondenserTile)this.tile).setLockInfoFromPacket(lockInfo);
    }
}

