/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class Relay
extends BlockDirection {
    private final EnumRelayTier tier;

    public Relay(EnumRelayTier tier, AbstractBlock.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumRelayTier getTier() {
        return this.tier;
    }

    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rtr) {
        RelayMK1Tile te;
        if (!world.field_72995_K && (te = WorldHelper.getTileEntity(RelayMK1Tile.class, (IBlockReader)world, pos, true)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        switch (this.tier) {
            case MK1: {
                return new RelayMK1Tile();
            }
            case MK2: {
                return new RelayMK2Tile();
            }
            case MK3: {
                return new RelayMK3Tile();
            }
        }
        return null;
    }

    @Deprecated
    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        RelayMK1Tile relay = WorldHelper.getTileEntity(RelayMK1Tile.class, (IBlockReader)world, pos, true);
        if (relay == null) {
            return 0;
        }
        return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
    }
}

