/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ToolTipEvent {
    @SubscribeEvent
    public static void tTipEvent(ItemTooltipEvent event) {
        long value;
        ItemStack current = event.getItemStack();
        if (current.func_190926_b()) {
            return;
        }
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (ProjectEConfig.client.pedestalToolTips.get()) {
            current.getCapability(ProjectEAPI.PEDESTAL_ITEM_CAPABILITY).ifPresent(pedestalItem -> {
                event.getToolTip().add(PELang.PEDESTAL_ON.translateColored(TextFormatting.DARK_PURPLE, new Object[0]));
                List<ITextComponent> description = pedestalItem.getPedestalDescription();
                if (description.isEmpty()) {
                    event.getToolTip().add(PELang.PEDESTAL_DISABLED.translateColored(TextFormatting.RED, new Object[0]));
                } else {
                    event.getToolTip().addAll(description);
                }
            });
        }
        if (ProjectEConfig.client.tagToolTips.get()) {
            for (ResourceLocation tag : ItemTags.func_199903_a().func_199913_a((Object)current.func_77973_b())) {
                event.getToolTip().add(new StringTextComponent("#" + tag));
            }
        }
        if (ProjectEConfig.client.emcToolTips.get() && (!ProjectEConfig.client.shiftEmcToolTips.get() || Screen.func_231173_s_()) && (value = EMCHelper.getEmcValue(current)) > 0L) {
            event.getToolTip().add(EMCHelper.getEmcTextComponent(value, 1));
            if (current.func_190916_E() > 1) {
                event.getToolTip().add(EMCHelper.getEmcTextComponent(value, current.func_190916_E()));
            }
            if (Screen.func_231173_s_() && clientPlayer != null && clientPlayer.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).map(k -> k.hasKnowledge(current)).orElse(false).booleanValue()) {
                event.getToolTip().add(PELang.EMC_HAS_KNOWLEDGE.translateColored(TextFormatting.YELLOW, new Object[0]));
            }
        }
        if (current.func_77942_o()) {
            CompoundNBT tag = current.func_196082_o();
            if (tag.func_150297_b("StoredEMC", 4)) {
                value = tag.func_74763_f("StoredEMC");
            } else {
                Optional holderCapability = current.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
                if (holderCapability.isPresent()) {
                    value = ((IItemEmcHolder)holderCapability.get()).getStoredEmc(current);
                } else {
                    return;
                }
            }
            event.getToolTip().add(PELang.EMC_STORED.translateColored(TextFormatting.YELLOW, TextFormatting.WHITE, Constants.EMC_FORMATTER.format(value)));
        }
    }
}

