/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.nbt.processor;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.nbt.INBTProcessor;
import moze_intel.projecte.api.nbt.NBTProcessor;
import moze_intel.projecte.utils.ItemInfoHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

@NBTProcessor
public class EnchantmentProcessor
implements INBTProcessor {
    private static final long ENCH_EMC_BONUS = 5000L;

    @Override
    public String getName() {
        return "EnchantmentProcessor";
    }

    @Override
    public String getDescription() {
        return "Increases the EMC value to take into account any enchantments on an item.";
    }

    @Override
    public boolean isAvailable() {
        return false;
    }

    @Override
    public boolean hasPersistentNBT() {
        return true;
    }

    @Override
    public boolean usePersistentNBT() {
        return false;
    }

    @Override
    public long recalculateEMC(@Nonnull ItemInfo info, long currentEMC) throws ArithmeticException {
        Map<Enchantment, Integer> enchants = ItemInfoHelper.getEnchantments(info);
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            int rarityWeight = entry.getKey().func_77324_c().func_185270_a();
            if (rarityWeight <= 0) continue;
            currentEMC = Math.addExact(currentEMC, Math.multiplyExact(5000L / (long)rarityWeight, (long)entry.getValue().intValue()));
        }
        return currentEMC;
    }

    @Override
    @Nullable
    public CompoundNBT getPersistentNBT(@Nonnull ItemInfo info) {
        CompoundNBT tag = info.getNBT();
        if (tag == null) {
            return null;
        }
        String location = ItemInfoHelper.getEnchantTagLocation(info);
        if (!tag.func_150297_b(location, 9)) {
            return null;
        }
        CompoundNBT toReturn = new CompoundNBT();
        ListNBT enchantments = tag.func_150295_c(location, 10);
        toReturn.func_218657_a(location, (INBT)enchantments);
        return toReturn;
    }
}

