/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.utils.AnnotationHelper;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.Registry;

@EMCMapper
public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private static final List<IRecipeTypeMapper> recipeMappers = new ArrayList<IRecipeTypeMapper>();

    public static void loadMappers() {
        if (recipeMappers.isEmpty()) {
            recipeMappers.addAll(AnnotationHelper.getRecipeTypeMappers());
        }
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, DataPackRegistries dataPackRegistries, IResourceManager resourceManager) {
        List<Object> unhandled;
        ResourceLocation typeRegistryName;
        NSSFake.setCurrentNamespace("craftingMapper");
        HashMap<ResourceLocation, RecipeCountInfo> recipeCount = new HashMap<ResourceLocation, RecipeCountInfo>();
        HashSet<ResourceLocation> canNotMap = new HashSet<ResourceLocation>();
        RecipeManager recipeManager = dataPackRegistries.func_240967_e_();
        NSSFakeGroupManager fakeGroupManager = new NSSFakeGroupManager();
        for (IRecipeType recipeType : Registry.field_218367_H) {
            typeRegistryName = Registry.field_218367_H.func_177774_c((Object)recipeType);
            boolean wasHandled = false;
            List<Object> recipes = null;
            unhandled = new ArrayList();
            for (IRecipeTypeMapper iRecipeTypeMapper : recipeMappers) {
                String configKey = this.getName() + "." + iRecipeTypeMapper.getName() + ".enabled";
                if (!EMCMappingHandler.getOrSetDefault(config, configKey, iRecipeTypeMapper.getDescription(), iRecipeTypeMapper.isAvailable()).booleanValue() || !iRecipeTypeMapper.canHandle(recipeType)) continue;
                if (recipes == null) {
                    recipes = recipeManager.func_241447_a_(recipeType);
                }
                int numHandled = 0;
                for (IRecipe iRecipe : recipes) {
                    try {
                        if (iRecipeTypeMapper.handleRecipe(mapper, iRecipe, fakeGroupManager)) {
                            ++numHandled;
                            continue;
                        }
                        unhandled.add(iRecipe);
                    }
                    catch (Exception e) {
                        PECore.LOGGER.fatal("A fatal error occurred while trying to map the recipe: {}", (Object)iRecipe.func_199560_c());
                        throw e;
                    }
                }
                if (numHandled <= 0 && !recipes.isEmpty()) continue;
                if (recipeCount.containsKey(typeRegistryName)) {
                    ((RecipeCountInfo)recipeCount.get(typeRegistryName)).setUnhandled(unhandled);
                } else {
                    recipeCount.put(typeRegistryName, new RecipeCountInfo(recipes.size(), unhandled));
                }
                wasHandled = true;
                if (unhandled.isEmpty()) break;
                recipes = unhandled;
                unhandled = new ArrayList();
            }
            if (wasHandled) continue;
            canNotMap.add(typeRegistryName);
        }
        PECore.debugLog("CraftingMapper Statistics:", new Object[0]);
        for (Map.Entry entry : recipeCount.entrySet()) {
            typeRegistryName = (ResourceLocation)entry.getKey();
            RecipeCountInfo countInfo = (RecipeCountInfo)entry.getValue();
            int total = countInfo.getTotalRecipes();
            unhandled = countInfo.getUnhandled();
            PECore.debugLog("Found and handled {} of {} Recipes of Type {}", total - unhandled.size(), total, typeRegistryName);
            if (unhandled.isEmpty()) continue;
            PECore.debugLog("Unhandled Recipes of Type {}:", typeRegistryName);
            for (IRecipe iRecipe : unhandled) {
                PECore.debugLog("Name: {}, Recipe class: {}", iRecipe.func_199560_c(), iRecipe.getClass().getName());
            }
        }
        for (ResourceLocation typeRegistryName2 : canNotMap) {
            PECore.debugLog("Could not map any Recipes of Type: {}", typeRegistryName2);
        }
        NSSFake.resetNamespace();
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.RecipeManager";
    }

    private static class NSSFakeGroupManager
    implements INSSFakeGroupManager {
        private final Map<Set<NormalizedSimpleStack>, NormalizedSimpleStack> groups = new HashMap<Set<NormalizedSimpleStack>, NormalizedSimpleStack>();
        private int fakeIndex;

        private NSSFakeGroupManager() {
        }

        @Override
        public Tuple<NormalizedSimpleStack, Boolean> getOrCreateFakeGroup(Set<NormalizedSimpleStack> normalizedSimpleStacks) {
            NormalizedSimpleStack stack = this.groups.get(normalizedSimpleStacks);
            if (stack == null) {
                stack = NSSFake.create(Integer.toString(this.fakeIndex++));
                this.groups.put(new HashSet<NormalizedSimpleStack>(normalizedSimpleStacks), stack);
                return new Tuple((Object)stack, (Object)true);
            }
            return new Tuple((Object)stack, (Object)false);
        }
    }

    private static class RecipeCountInfo {
        private final int totalRecipes;
        private List<IRecipe<?>> unhandled;

        private RecipeCountInfo(int totalRecipes, List<IRecipe<?>> unhandled) {
            this.totalRecipes = totalRecipes;
            this.unhandled = unhandled;
        }

        public int getTotalRecipes() {
            return this.totalRecipes;
        }

        public void setUnhandled(List<IRecipe<?>> unhandled) {
            this.unhandled = unhandled;
        }

        public List<IRecipe<?>> getUnhandled() {
            return this.unhandled;
        }
    }
}

