/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public final class NSSItem
extends AbstractNBTNSSTag<Item> {
    private NSSItem(@Nonnull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundNBT nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        if (stack.func_77984_f() && stack.func_77942_o() && stack.func_196082_o().equals((Object)new ItemStack((IItemProvider)stack.func_77973_b()).func_77978_p())) {
            return NSSItem.createItem((IItemProvider)stack.func_77973_b(), null);
        }
        return NSSItem.createItem((IItemProvider)stack.func_77973_b(), stack.func_77978_p());
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull IItemProvider itemProvider) {
        return NSSItem.createItem(itemProvider, null);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull IItemProvider itemProvider, @Nullable CompoundNBT nbt) {
        Item item = itemProvider.func_199767_j();
        if (item == Items.field_190931_a) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        return NSSItem.createItem(item.getRegistryName(), nbt);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ResourceLocation itemID) {
        return NSSItem.createItem(itemID, null);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ResourceLocation itemID, @Nullable CompoundNBT nbt) {
        return new NSSItem(itemID, false, nbt);
    }

    @Nonnull
    public static NSSItem createTag(@Nonnull ResourceLocation tagId) {
        return new NSSItem(tagId, true, null);
    }

    @Nonnull
    public static NSSItem createTag(@Nonnull ITag<Item> tag) {
        ResourceLocation tagLocation = TagCollectionManager.func_242178_a().func_241836_b().func_232973_a_(tag);
        if (tagLocation == null) {
            throw new IllegalArgumentException("Can't make NSSItem with a tag that does not exist");
        }
        return NSSItem.createTag(tagLocation);
    }

    @Override
    protected boolean isInstance(AbstractNSSTag<?> o) {
        return o instanceof NSSItem;
    }

    @Override
    @Nonnull
    public String getJsonPrefix() {
        return "";
    }

    @Override
    @Nonnull
    public String getType() {
        return "Item";
    }

    @Override
    @Nonnull
    protected ITagCollection<Item> getTagCollection() {
        return TagCollectionManager.func_242178_a().func_241836_b();
    }

    @Override
    protected Function<Item, NormalizedSimpleStack> createNew() {
        return NSSItem::createItem;
    }
}

