/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CustomConversionProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, CustomConversionBuilder> customConversions = new LinkedHashMap<ResourceLocation, CustomConversionBuilder>();
    private final DataGenerator generator;

    protected CustomConversionProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public final void func_200398_a(DirectoryCache cache) {
        this.customConversions.clear();
        this.addCustomConversions();
        for (Map.Entry<ResourceLocation, CustomConversionBuilder> entry : this.customConversions.entrySet()) {
            ResourceLocation customConversion = entry.getKey();
            Path path = this.generator.func_200391_b().resolve("data/" + customConversion.func_110624_b() + "/pe_custom_conversions/" + customConversion.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)entry.getValue().serialize(), (Path)path);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't save custom conversion file for conversion: " + customConversion, e);
            }
        }
    }

    protected abstract void addCustomConversions();

    protected CustomConversionBuilder createConversionBuilder(ResourceLocation id) {
        Objects.requireNonNull(id, "Custom Conversion Builder ID cannot be null.");
        if (this.customConversions.containsKey(id)) {
            throw new RuntimeException("Custom conversion '" + id + "' has already been registered.");
        }
        CustomConversionBuilder conversionBuilder = new CustomConversionBuilder(id);
        this.customConversions.put(id, conversionBuilder);
        return conversionBuilder;
    }

    public String func_200397_b() {
        return "Custom EMC Conversions";
    }
}

