/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.data.ConversionGroupBuilder;
import moze_intel.projecte.api.data.CustomConversionBuilderNSSHelper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomConversionBuilder
implements CustomConversionBuilderNSSHelper {
    private static final long FREE_ARITHMETIC_VALUE = Long.MIN_VALUE;
    private final Map<String, ConversionGroupBuilder> groups = new LinkedHashMap<String, ConversionGroupBuilder>();
    private final Map<NormalizedSimpleStack, Long> fixedValueBefore = new LinkedHashMap<NormalizedSimpleStack, Long>();
    private final Map<NormalizedSimpleStack, Long> fixedValueAfter = new LinkedHashMap<NormalizedSimpleStack, Long>();
    private final List<FixedValueConversionBuilder> fixedValueConversions = new ArrayList<FixedValueConversionBuilder>();
    private final ResourceLocation id;
    private boolean replace;
    @Nullable
    private String comment;

    CustomConversionBuilder(ResourceLocation id) {
        this.id = id;
    }

    public CustomConversionBuilder comment(String comment) {
        CustomConversionBuilder.validateComment(this.comment, comment, "Custom Conversion");
        this.comment = comment;
        return this;
    }

    public CustomConversionBuilder replace() {
        if (this.replace) {
            throw new RuntimeException("Replace has already been set, remove unnecessary call.");
        }
        this.replace = true;
        return this;
    }

    public ConversionGroupBuilder group(String groupName) {
        Objects.requireNonNull(groupName, "Group name cannot be null.");
        if (this.groups.containsKey(groupName)) {
            throw new RuntimeException("Group with name '" + groupName + "' already exists.");
        }
        ConversionGroupBuilder builder = new ConversionGroupBuilder(this);
        this.groups.put(groupName, builder);
        return builder;
    }

    @Override
    public CustomConversionBuilder before(NormalizedSimpleStack stack, long emc) {
        return this.fixedValue(stack, emc, this.fixedValueBefore, "before");
    }

    @Override
    public CustomConversionBuilder before(NormalizedSimpleStack stack) {
        return this.fixedValue(stack, Long.MIN_VALUE, this.fixedValueBefore, "before");
    }

    @Override
    public CustomConversionBuilder after(NormalizedSimpleStack stack, long emc) {
        return this.fixedValue(stack, emc, this.fixedValueAfter, "after");
    }

    @Override
    public CustomConversionBuilder after(NormalizedSimpleStack stack) {
        return this.fixedValue(stack, Long.MIN_VALUE, this.fixedValueAfter, "after");
    }

    private CustomConversionBuilder fixedValue(NormalizedSimpleStack stack, long emc, Map<NormalizedSimpleStack, Long> fixedValues, String type) {
        Objects.requireNonNull(stack, "Normalized Simple Stack cannot be null.");
        if (emc < 1L && emc != Long.MIN_VALUE) {
            throw new IllegalArgumentException("EMC value must be at least one.");
        }
        if (fixedValues.containsKey(stack)) {
            throw new RuntimeException("Fixed value " + type + " already set for '" + stack + "'.");
        }
        fixedValues.put(stack, emc);
        return this;
    }

    @Override
    public FixedValueConversionBuilder conversion(NormalizedSimpleStack output, int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("Output amount for fixed value conversions must be at least one.");
        }
        FixedValueConversionBuilder builder = new FixedValueConversionBuilder(output, amount);
        this.fixedValueConversions.add(builder);
        return builder;
    }

    JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.comment != null) {
            json.addProperty("comment", this.comment);
        }
        if (this.replace) {
            json.addProperty("replace", Boolean.valueOf(true));
        }
        if (!this.groups.isEmpty()) {
            JsonObject jsonGroups = new JsonObject();
            for (Map.Entry<String, ConversionGroupBuilder> entry : this.groups.entrySet()) {
                String groupName = entry.getKey();
                ConversionGroupBuilder group = entry.getValue();
                JsonObject groupJson = group.serialize();
                CustomConversionBuilder.validateNonEmpty(groupJson, group.hasComment(), "Group", groupName);
                jsonGroups.add(groupName, (JsonElement)groupJson);
            }
            json.add("groups", (JsonElement)jsonGroups);
        }
        if (!(this.fixedValueBefore.isEmpty() && this.fixedValueAfter.isEmpty() && this.fixedValueConversions.isEmpty())) {
            JsonObject fixedValues = new JsonObject();
            if (!this.fixedValueBefore.isEmpty()) {
                fixedValues.add("before", (JsonElement)CustomConversionBuilder.serializeFixedValues(this.fixedValueBefore));
            }
            if (!this.fixedValueAfter.isEmpty()) {
                fixedValues.add("after", (JsonElement)CustomConversionBuilder.serializeFixedValues(this.fixedValueAfter));
            }
            if (!this.fixedValueConversions.isEmpty()) {
                fixedValues.add("conversion", (JsonElement)CustomConversionBuilder.serializeConversions(this.fixedValueConversions));
            }
            json.add("values", (JsonElement)fixedValues);
        }
        CustomConversionBuilder.validateNonEmpty(json, this.comment != null, "Custom conversion", this.id.toString());
        return json;
    }

    private static void validateNonEmpty(JsonObject json, boolean hasComment, String type, String name) {
        int elements = json.size();
        if (elements == 0) {
            throw new RuntimeException(type + " '" + name + "' is empty and should be removed.");
        }
        if (elements == 1 && hasComment) {
            throw new RuntimeException(type + " '" + name + "' consists only of a comment and should be removed.");
        }
    }

    private static JsonObject serializeFixedValues(Map<NormalizedSimpleStack, Long> fixedValues) {
        JsonObject json = new JsonObject();
        for (Map.Entry<NormalizedSimpleStack, Long> entry : fixedValues.entrySet()) {
            String key = entry.getKey().json();
            long emc = entry.getValue();
            if (emc == Long.MIN_VALUE) {
                json.addProperty(key, "free");
                continue;
            }
            json.addProperty(key, (Number)emc);
        }
        return json;
    }

    static JsonArray serializeConversions(List<? extends ConversionBuilder<?>> conversions) {
        HashSet<JsonObject> addedConversions = new HashSet<JsonObject>();
        JsonArray jsonConversions = new JsonArray();
        for (ConversionBuilder<?> conversion : conversions) {
            JsonObject jsonConversion = conversion.serialize();
            if (addedConversions.add(jsonConversion)) {
                jsonConversions.add((JsonElement)jsonConversion);
                continue;
            }
            throw new RuntimeException("Duplicate conversion: " + conversion + ". This is likely a copy paste error and should be removed.");
        }
        return jsonConversions;
    }

    static void validateComment(@Nullable String currentComment, String comment, String location) {
        Objects.requireNonNull(comment, "Comment defaults to null, remove unnecessary call.");
        if (currentComment != null) {
            throw new RuntimeException(location + " Builder already has a comment declared.");
        }
    }

    public class FixedValueConversionBuilder
    extends ConversionBuilder<FixedValueConversionBuilder> {
        private FixedValueConversionBuilder(NormalizedSimpleStack output, int count) {
            super(output, count);
        }

        public CustomConversionBuilder end() {
            this.validateIngredients();
            return CustomConversionBuilder.this;
        }
    }
}

