/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
interface ConversionBuilderNSSHelper<BUILDER extends ConversionBuilder<BUILDER>> {
    public BUILDER ingredient(NormalizedSimpleStack var1, int var2);

    default public BUILDER ingredient(NormalizedSimpleStack input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(ItemStack input) {
        return this.ingredient(NSSItem.createItem(input), input.func_190916_E());
    }

    default public BUILDER ingredient(IItemProvider input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(IItemProvider input, int amount) {
        return this.ingredient(NSSItem.createItem(input), amount);
    }

    default public BUILDER ingredient(ITag<Item> input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(ITag<Item> input, int amount) {
        return this.ingredient(NSSItem.createTag(input), amount);
    }

    default public BUILDER ingredient(FluidStack input) {
        return this.ingredient(NSSFluid.createFluid(input), input.getAmount());
    }

    default public BUILDER ingredient(Fluid input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(Fluid input, int amount) {
        return this.ingredient(NSSFluid.createFluid(input), amount);
    }

    default public BUILDER ingredientFluid(ITag<Fluid> input) {
        return this.ingredientFluid(input, 1);
    }

    default public BUILDER ingredientFluid(ITag<Fluid> input, int amount) {
        return this.ingredient(NSSFluid.createTag(input), amount);
    }

    default public BUILDER ingredient(String fake) {
        return this.ingredient(fake, 1);
    }

    default public BUILDER ingredient(String fake, int amount) {
        return this.ingredient(NSSFake.create(fake), amount);
    }
}

