/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.config.PEModConfig;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.EMCReloadListener;
import moze_intel.projecte.emc.json.NSSSerializer;
import moze_intel.projecte.emc.mappers.recipe.CraftingMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.customRecipes.FullKleinStarIngredient;
import moze_intel.projecte.gameObjs.customRecipes.FullKleinStarsCondition;
import moze_intel.projecte.gameObjs.customRecipes.TomeEnabledCondition;
import moze_intel.projecte.gameObjs.items.rings.Arcana;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.registries.PEEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.gameObjs.registries.PERecipeSerializers;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.handlers.CommonInternalAbilities;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.IMCHandler;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.impl.capability.AlchBagItemDefaultImpl;
import moze_intel.projecte.impl.capability.AlchChestItemDefaultImpl;
import moze_intel.projecte.impl.capability.ChargeItemDefaultImpl;
import moze_intel.projecte.impl.capability.EmcHolderItemDefaultImpl;
import moze_intel.projecte.impl.capability.EmcStorageDefaultImpl;
import moze_intel.projecte.impl.capability.ExtraFunctionItemDefaultImpl;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.impl.capability.ModeChangerItemDefaultImpl;
import moze_intel.projecte.impl.capability.PedestalItemDefaultImpl;
import moze_intel.projecte.impl.capability.ProjectileShooterItemDefaultImpl;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.ThreadCheckUUID;
import moze_intel.projecte.network.ThreadCheckUpdate;
import moze_intel.projecte.network.commands.ClearKnowledgeCMD;
import moze_intel.projecte.network.commands.DumpMissingEmc;
import moze_intel.projecte.network.commands.RemoveEmcCMD;
import moze_intel.projecte.network.commands.ResetEmcCMD;
import moze_intel.projecte.network.commands.SetEmcCMD;
import moze_intel.projecte.network.commands.ShowBagCMD;
import moze_intel.projecte.network.commands.argument.ColorArgument;
import moze_intel.projecte.network.commands.argument.NSSItemArgument;
import moze_intel.projecte.network.commands.argument.UUIDArgument;
import moze_intel.projecte.utils.DummyIStorage;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.dispenser.BeehiveDispenseBehavior;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projecte")
@Mod.EventBusSubscriber(modid="projecte")
public class PECore {
    public static final String MODID = "projecte";
    public static final String MODNAME = "ProjectE";
    public static final GameProfile FAKEPLAYER_GAMEPROFILE = new GameProfile(UUID.fromString("590e39c7-9fb6-471b-a4c2-c0e539b2423d"), "[ProjectE]");
    public static final Logger LOGGER = LogManager.getLogger((String)"projecte");
    public static final List<String> uuids = new ArrayList<String>();
    public static ModContainer MOD_CONTAINER;

    public static void debugLog(String msg, Object ... args) {
        if (!FMLEnvironment.production || ProjectEConfig.common.debugLogging.get()) {
            LOGGER.info(msg, args);
        } else {
            LOGGER.debug(msg, args);
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public PECore() {
        MOD_CONTAINER = ModLoadingContext.get().getActiveContainer();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::imcQueue);
        modEventBus.addListener(this::imcHandle);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        PEBlocks.BLOCKS.register(modEventBus);
        PEContainerTypes.CONTAINER_TYPES.register(modEventBus);
        PEEntityTypes.ENTITY_TYPES.register(modEventBus);
        PEItems.ITEMS.register(modEventBus);
        PERecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        PESoundEvents.SOUND_EVENTS.register(modEventBus);
        PETileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverQuit);
        ProjectEConfig.register();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register(TomeEnabledCondition.SERIALIZER);
        CraftingHelper.register(FullKleinStarsCondition.SERIALIZER);
        CraftingHelper.register((ResourceLocation)PECore.rl("full_klein_star"), FullKleinStarIngredient.SERIALIZER);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AlchBagImpl.init();
        KnowledgeImpl.init();
        CapabilityManager.INSTANCE.register(InternalTimers.class, new DummyIStorage(), InternalTimers::new);
        CapabilityManager.INSTANCE.register(InternalAbilities.class, new DummyIStorage(), () -> new InternalAbilities(null));
        CapabilityManager.INSTANCE.register(CommonInternalAbilities.class, new DummyIStorage(), () -> new CommonInternalAbilities(null));
        CapabilityManager.INSTANCE.register(IAlchBagItem.class, new DummyIStorage(), AlchBagItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IAlchChestItem.class, new DummyIStorage(), AlchChestItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IExtraFunction.class, new DummyIStorage(), ExtraFunctionItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IItemCharge.class, new DummyIStorage(), ChargeItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IItemEmcHolder.class, new DummyIStorage(), EmcHolderItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IModeChanger.class, new DummyIStorage(), ModeChangerItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IPedestalItem.class, new DummyIStorage(), PedestalItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IProjectileShooter.class, new DummyIStorage(), ProjectileShooterItemDefaultImpl::new);
        CapabilityManager.INSTANCE.register(IEmcStorage.class, new DummyIStorage(), EmcStorageDefaultImpl::new);
        new ThreadCheckUpdate().start();
        EMCMappingHandler.loadMappers();
        CraftingMapper.loadMappers();
        NBTManager.loadProcessors();
        event.enqueueWork(() -> {
            PacketHandler.register();
            PECore.registerDispenseBehavior((IDispenseItemBehavior)new BeehiveDispenseBehavior(), PEItems.DARK_MATTER_SHEARS, PEItems.RED_MATTER_SHEARS, PEItems.RED_MATTER_KATAR);
            DispenserBlock.func_199774_a(PEBlocks.NOVA_CATALYST, (IDispenseItemBehavior)PEBlocks.NOVA_CATALYST.getBlock().createDispenseItemBehavior());
            DispenserBlock.func_199774_a(PEBlocks.NOVA_CATACLYSM, (IDispenseItemBehavior)PEBlocks.NOVA_CATACLYSM.getBlock().createDispenseItemBehavior());
            PECore.registerDispenseBehavior((IDispenseItemBehavior)new OptionalDispenseBehavior(){

                @Nonnull
                protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                    Arcana item;
                    if (stack.func_77973_b() instanceof Arcana && (item = (Arcana)stack.func_77973_b()).getMode(stack) != 1) {
                        this.func_239796_a_(false);
                        return super.func_82487_b(source, stack);
                    }
                    ServerWorld world = source.func_197524_h();
                    this.func_239796_a_(true);
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    BlockPos pos = source.func_180699_d().func_177972_a(direction);
                    BlockState state = world.func_180495_p(pos);
                    if (AbstractFireBlock.func_241465_a_((World)world, (BlockPos)pos, (Direction)direction)) {
                        world.func_175656_a(pos, AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)pos));
                    } else if (CampfireBlock.func_241470_h_((BlockState)state)) {
                        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                    } else if (state.isFlammable((IBlockReader)world, pos, direction.func_176734_d())) {
                        state.catchFire((World)world, pos, direction.func_176734_d(), null);
                        if (state.func_177230_c() instanceof TNTBlock) {
                            world.func_217377_a(pos, false);
                        }
                    } else {
                        this.func_239796_a_(false);
                    }
                    return stack;
                }
            }, PEItems.IGNITION_RING, PEItems.ARCANA_RING);
            DispenserBlock.func_199774_a(PEItems.EVERTIDE_AMULET, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

                @Nonnull
                public ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
                    Optional capability;
                    ServerWorld world = source.func_197524_h();
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    BlockPos pos = source.func_180699_d().func_177972_a(direction);
                    TileEntity tile = WorldHelper.getTileEntity((IBlockReader)world, pos);
                    Direction sideHit = direction.func_176734_d();
                    if (tile != null && (capability = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit).resolve()).isPresent()) {
                        ((IFluidHandler)capability.get()).fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                        return stack;
                    }
                    BlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == Blocks.field_150383_bp) {
                        int waterLevel = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
                        if (waterLevel < 3) {
                            ((CauldronBlock)state.func_177230_c()).func_176590_a((World)world, pos, state, waterLevel + 1);
                            return stack;
                        }
                    } else {
                        WorldHelper.placeFluid(null, (World)world, pos, Fluids.field_204546_a, !ProjectEConfig.server.items.opEvertide.get());
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)PESoundEvents.WATER_MAGIC.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return stack;
                    }
                    return super.func_82487_b(source, stack);
                }
            });
            ArgumentTypes.func_218136_a((String)"projecte:uuid", UUIDArgument.class, (IArgumentSerializer)new ArgumentSerializer(UUIDArgument::new));
            ArgumentTypes.func_218136_a((String)"projecte:color", ColorArgument.class, (IArgumentSerializer)new ArgumentSerializer(ColorArgument::new));
            ArgumentTypes.func_218136_a((String)"projecte:nss", NSSItemArgument.class, (IArgumentSerializer)new ArgumentSerializer(NSSItemArgument::new));
        });
    }

    private static void registerDispenseBehavior(IDispenseItemBehavior behavior, IItemProvider ... items) {
        for (IItemProvider item : items) {
            DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)behavior);
        }
    }

    private void imcQueue(InterModEnqueueEvent event) {
        WorldTransmutations.init();
        NSSSerializer.init();
        IntegrationHelper.sendIMCMessages(event);
    }

    private void imcHandle(InterModProcessEvent event) {
        IMCHandler.handleMessages();
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof PEModConfig) {
            ((PEModConfig)config).clearCache();
        }
    }

    private void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new EMCReloadListener(event.getDataPackRegistries()));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)MODID).then(ClearKnowledgeCMD.register())).then(DumpMissingEmc.register())).then(RemoveEmcCMD.register())).then(ResetEmcCMD.register())).then(SetEmcCMD.register())).then(ShowBagCMD.register());
        event.getDispatcher().register(root);
    }

    private void serverStarting(FMLServerStartingEvent event) {
        if (!ThreadCheckUUID.hasRunServer()) {
            new ThreadCheckUUID(true).start();
        }
    }

    private void serverQuit(FMLServerStoppedEvent event) {
        CustomEMCParser.flush();
        TransmutationOffline.cleanAll();
        EMCMappingHandler.clearEmcMap();
    }
}

