/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.helper.category;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.impl.util.NameUtils;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.jeitweaker.helper.category.JeiCategoryCreator;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class JeiCategoryHelper {
    private static final Map<Class<?>, JeiCategoryCreator<?>> CREATORS = (Map)Util.func_200696_a(new HashMap(), JeiCategoryHelper::lookup);

    public static void initialize() {
    }

    public static <T extends JeiCategory> T of(Class<T> typeToken, String id, MCTextComponent name, JeiDrawable icon, RawJeiIngredient[] catalysts, Consumer<T> configurator) {
        ResourceLocation checkedId = NameUtils.fromFixedName((String)id, (fixed, mistakes) -> CraftTweakerAPI.logWarning((String)"Invalid category ID '%s' specified due to the following mistakes:\n%s\nThe new rename will be '%s'", (Object[])new Object[]{id, String.join((CharSequence)"\n", mistakes), fixed}));
        return (T)((JeiCategory)Util.func_200696_a(JeiCategoryHelper.of(typeToken).of(checkedId, name, icon, catalysts), configurator));
    }

    private static <T extends JeiCategory> JeiCategoryCreator<T> of(Class<T> type) {
        return Objects.requireNonNull(CREATORS.get(type), () -> "Invalid category type supplied: " + type.getName());
    }

    private static void lookup(Map<Class<?>, JeiCategoryCreator<?>> map) {
        CraftTweakerRegistry.getZenClassRegistry().getImplementationsOf(JeiCategory.class).stream().filter(type -> !Modifier.isAbstract(type.getModifiers())).forEach(type -> JeiCategoryCreator.of(type).ifPresent(creator -> map.put((Class<?>)type, (JeiCategoryCreator<?>)creator)));
    }
}

