/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.helper.category;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.jeitweaker.helper.category.JeiCategoryCreator;
import com.blamejared.jeitweaker.helper.category.JeiCategoryCreatorLoader;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.component.RawJeiIngredient;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.util.ResourceLocation;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

enum JeiCategoryCreatorGenerator {
    INSTANCE;

    private static final String OBJECT_INTERNAL_NAME;
    private static final String CATEGORY_CREATOR_INTERNAL_NAME;
    private static final String OF_DESCRIPTOR;
    private static final String TARGET_DESCRIPTOR;
    private static final JeiCategoryCreatorLoader LOADER;

    <T extends JeiCategory> Optional<JeiCategoryCreator<T>> generate(Class<T> typeToken) {
        return this.lookup(typeToken).map(this::generate).map(this::instantiate);
    }

    private <T extends JeiCategory> Optional<Constructor<T>> lookup(Class<T> typeToken) {
        try {
            return Optional.of(typeToken.getConstructor(ResourceLocation.class, MCTextComponent.class, JeiDrawable.class, RawJeiIngredient[].class));
        }
        catch (NoSuchMethodException e) {
            CraftTweakerAPI.logThrowing((String)"Unable to generate category creator for class {} because no compatible constructor was found", (Throwable)e, (Object[])new Object[]{typeToken.getName()});
            return Optional.empty();
        }
    }

    private <T extends JeiCategory> String generate(Constructor<T> constructor) {
        String className = String.format("%s$%s$%s", JeiCategoryCreator.class.getName(), constructor.getDeclaringClass().getSimpleName(), Integer.toUnsignedString(ThreadLocalRandom.current().nextInt()));
        String classInternalName = className.replace('.', '/');
        String targetClassInternalName = constructor.getDeclaringClass().getName().replace('.', '/');
        byte[] classData = this.generate(classInternalName, targetClassInternalName);
        LOADER.addClass(className, classData);
        return className;
    }

    private byte[] generate(String thisInternalName, String targetInternalName) {
        ClassWriter writer = new ClassWriter(0);
        this.createHeader(writer, thisInternalName);
        this.createConstructor(writer);
        this.createOverride(writer, targetInternalName);
        return this.finish(writer);
    }

    private void createHeader(ClassWriter writer, String thisInternalName) {
        int version = 52;
        int access = 4129;
        writer.visit(52, 4129, thisInternalName, null, OBJECT_INTERNAL_NAME, new String[]{CATEGORY_CREATOR_INTERNAL_NAME});
        writer.visitSource(".dyngen", null);
    }

    private void createConstructor(ClassWriter writer) {
        MethodVisitor init = writer.visitMethod(1, "<init>", "()V", null, null);
        init.visitCode();
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, OBJECT_INTERNAL_NAME, "<init>", "()V", false);
        init.visitInsn(177);
        init.visitMaxs(1, 1);
        init.visitEnd();
    }

    private void createOverride(ClassWriter writer, String targetName) {
        MethodVisitor of = writer.visitMethod(1, "of", OF_DESCRIPTOR, null, null);
        of.visitCode();
        of.visitTypeInsn(187, targetName);
        of.visitInsn(89);
        of.visitVarInsn(25, 1);
        of.visitVarInsn(25, 2);
        of.visitVarInsn(25, 3);
        of.visitVarInsn(25, 4);
        of.visitMethodInsn(183, targetName, "<init>", TARGET_DESCRIPTOR, false);
        of.visitInsn(176);
        of.visitMaxs(6, 5);
        of.visitEnd();
    }

    private byte[] finish(ClassWriter writer) {
        writer.visitEnd();
        return writer.toByteArray();
    }

    private <T extends JeiCategory> JeiCategoryCreator<T> instantiate(String name) {
        try {
            return (JeiCategoryCreator)LOADER.loadClass(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("A critical error was encountered when initializing category creator " + name, e);
        }
    }

    static {
        OBJECT_INTERNAL_NAME = Type.getInternalName(Object.class);
        CATEGORY_CREATOR_INTERNAL_NAME = Type.getInternalName(JeiCategoryCreator.class);
        OF_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(JeiCategory.class), (Type[])new Type[]{Type.getType(ResourceLocation.class), Type.getType(MCTextComponent.class), Type.getType(JeiDrawable.class), Type.getType(RawJeiIngredient[].class)});
        TARGET_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(ResourceLocation.class), Type.getType(MCTextComponent.class), Type.getType(JeiDrawable.class), Type.getType(RawJeiIngredient[].class)});
        LOADER = new JeiCategoryCreatorLoader(JeiCategoryCreatorGenerator.class.getClassLoader());
    }
}

