/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.collect.Streams;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.api.distmarker.OnlyIns;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class RuntimeDistCleaner
implements ILaunchPluginService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker DISTXFORM = MarkerManager.getMarker((String)"DISTXFORM");
    private static String DIST;
    private static final String ONLYIN;
    private static final String ONLYINS;
    private static final EnumSet<ILaunchPluginService.Phase> YAY;
    private static final EnumSet<ILaunchPluginService.Phase> NAY;

    public String name() {
        return "runtimedistcleaner";
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        AtomicBoolean changes = new AtomicBoolean();
        if (this.remove(classNode.visibleAnnotations, DIST)) {
            LOGGER.fatal(DISTXFORM, "Attempted to load class {} for invalid dist {}", (Object)classNode.name, (Object)DIST);
            throw new RuntimeException("Attempted to load class " + classNode.name + " for invalid dist " + DIST);
        }
        if (classNode.interfaces != null) {
            RuntimeDistCleaner.unpack(classNode.visibleAnnotations).stream().filter(ann -> Objects.equals(ann.desc, ONLYIN)).filter(ann -> ann.values.indexOf("_interface") != -1).filter(ann -> !Objects.equals(((String[])ann.values.get(ann.values.indexOf("value") + 1))[1], DIST)).map(ann -> ((Type)ann.values.get(ann.values.indexOf("_interface") + 1)).getInternalName()).forEach(intf -> {
                if (classNode.interfaces.remove(intf)) {
                    LOGGER.debug(DISTXFORM, "Removing Interface: {} implements {}", (Object)classNode.name, intf);
                    changes.compareAndSet(false, true);
                }
            });
            if (classNode.visibleAnnotations != null) {
                Iterator itr = classNode.visibleAnnotations.iterator();
                while (itr.hasNext()) {
                    AnnotationNode ann2 = (AnnotationNode)itr.next();
                    if (!Objects.equals(ann2.desc, ONLYIN) && !Objects.equals(ann2.desc, ONLYINS)) continue;
                    LOGGER.debug(DISTXFORM, "Removing Class Annotation: {} @{}", (Object)classNode.name, (Object)ann2.desc);
                    itr.remove();
                    changes.compareAndSet(false, true);
                }
            }
        }
        Iterator fields = classNode.fields.iterator();
        while (fields.hasNext()) {
            FieldNode field = (FieldNode)fields.next();
            if (!this.remove(field.visibleAnnotations, DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing field: {}.{}", (Object)classNode.name, (Object)field.name);
            fields.remove();
            changes.compareAndSet(false, true);
        }
        LambdaGatherer lambdaGatherer = new LambdaGatherer();
        Iterator methods = classNode.methods.iterator();
        while (methods.hasNext()) {
            MethodNode method = (MethodNode)methods.next();
            if (!this.remove(method.visibleAnnotations, DIST)) continue;
            LOGGER.debug(DISTXFORM, "Removing method: {}.{}{}", (Object)classNode.name, (Object)method.name, (Object)method.desc);
            methods.remove();
            lambdaGatherer.accept(method);
            changes.compareAndSet(false, true);
        }
        List<Handle> dynamicLambdaHandles = lambdaGatherer.getDynamicLambdaHandles();
        while (!dynamicLambdaHandles.isEmpty()) {
            lambdaGatherer = new LambdaGatherer();
            methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if ((method.access & 0x1000) == 0) continue;
                for (Handle dynamicLambdaHandle : dynamicLambdaHandles) {
                    if (!method.name.equals(dynamicLambdaHandle.getName()) || !method.desc.equals(dynamicLambdaHandle.getDesc())) continue;
                    LOGGER.debug(DISTXFORM, "Removing lambda method: {}.{}{}", (Object)classNode.name, (Object)method.name, (Object)method.desc);
                    methods.remove();
                    lambdaGatherer.accept(method);
                    changes.compareAndSet(false, true);
                }
            }
            dynamicLambdaHandles = lambdaGatherer.getDynamicLambdaHandles();
        }
        return changes.get() ? 256 : 0;
    }

    private static List<AnnotationNode> unpack(List<AnnotationNode> anns) {
        if (anns == null) {
            return Collections.emptyList();
        }
        List<AnnotationNode> ret = anns.stream().filter(ann -> Objects.equals(ann.desc, ONLYIN)).collect(Collectors.toList());
        anns.stream().filter(ann -> Objects.equals(ann.desc, ONLYINS) && ann.values != null).map(ann -> (List)ann.values.get(ann.values.indexOf("value") + 1)).filter(v -> v != null).forEach(v -> v.forEach(ret::add));
        return ret;
    }

    private boolean remove(List<AnnotationNode> anns, String side) {
        return RuntimeDistCleaner.unpack(anns).stream().filter(ann -> Objects.equals(ann.desc, ONLYIN)).filter(ann -> ann.values.indexOf("_interface") == -1).anyMatch(ann -> !Objects.equals(((String[])ann.values.get(ann.values.indexOf("value") + 1))[1], side));
    }

    public Consumer<Dist> getExtension() {
        return s -> {
            DIST = s.name();
            LOGGER.debug(DISTXFORM, "Configuring for Dist {}", (Object)DIST);
        };
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return isEmpty ? NAY : YAY;
    }

    static {
        ONLYIN = Type.getDescriptor(OnlyIn.class);
        ONLYINS = Type.getDescriptor(OnlyIns.class);
        YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
        NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    }

    private static class LambdaGatherer
    extends MethodVisitor {
        private static final Handle META_FACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        private final List<Handle> dynamicLambdaHandles = new ArrayList<Handle>();

        public LambdaGatherer() {
            super(589824);
        }

        public void accept(MethodNode method) {
            Streams.stream((Iterator)method.instructions.iterator()).filter(insnNode -> insnNode.getType() == 6).forEach(insnNode -> insnNode.accept((MethodVisitor)this));
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORY.equals(bsm)) {
                Handle dynamicLambdaHandle = (Handle)bsmArgs[1];
                this.dynamicLambdaHandles.add(dynamicLambdaHandle);
            }
        }

        public List<Handle> getDynamicLambdaHandles() {
            return this.dynamicLambdaHandles;
        }
    }
}

