/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import mezz.jei.config.IWorldConfig;
import mezz.jei.network.PacketIdClient;
import mezz.jei.network.packets.IPacketJeiHandler;
import mezz.jei.network.packets.PacketCheatPermission;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PacketHandlerClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public final EnumMap<PacketIdClient, IPacketJeiHandler> clientHandlers = new EnumMap(PacketIdClient.class);

    public PacketHandlerClient(IWorldConfig worldConfig) {
        this.clientHandlers.put(PacketIdClient.CHEAT_PERMISSION, (buf, player) -> PacketCheatPermission.readPacketData(buf, player, worldConfig));
    }

    public void onPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        try {
            ClientPlayerEntity player;
            PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)event.getPayload());
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            IPacketJeiHandler packetHandler = this.clientHandlers.get(packetId);
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft != null && (player = minecraft.field_71439_g) != null) {
                packetHandler.readPacketData(packetBuffer, (PlayerEntity)player);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Packet error", e);
        }
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }
}

