/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.BufferUtils;

public class Tooltips {
    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, borderColorStart, borderColorEnd, comparison, false);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColor, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain) {
        Tooltips.renderItemTooltip(stack, matrixStack, info, rect, screenWidth, screenHeight, backgroundColor, backgroundColor, borderColorStart, borderColorEnd, comparison, constrain, false, 0);
    }

    public static void renderItemTooltip(@Nonnull ItemStack stack, MatrixStack matrixStack, TooltipInfo info, Rectangle2d rect, int screenWidth, int screenHeight, int backgroundColorStart, int backgroundColorEnd, int borderColorStart, int borderColorEnd, boolean comparison, boolean constrain, boolean centeredTitle, int index) {
        if (info.getLines().isEmpty()) {
            return;
        }
        int rectX = rect.func_199318_a() + 4;
        int rectY = rect.func_199319_b() + 4;
        int maxTextWidth = rect.func_199316_c();
        RenderTooltipExtEvent.Pre preEvent = new RenderTooltipExtEvent.Pre(stack, info.getLines(), matrixStack, rectX, rectY, screenWidth, screenHeight, maxTextWidth, info.getFont(), comparison, index);
        if (MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        rectX = preEvent.getX();
        rectY = preEvent.getY();
        screenWidth = preEvent.getScreenWidth();
        screenHeight = preEvent.getScreenHeight();
        maxTextWidth = preEvent.getMaxWidth();
        info.setFont(preEvent.getFontRenderer());
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = info.getMaxLineWidth();
        if (constrain) {
            // empty if block
        }
        if (tooltipTextWidth > maxTextWidth) {
            info.wrap(maxTextWidth);
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getLines(), info.getFont(), rect.func_199316_c(), info.getTitleLines()), info.getFont(), info.getTitleLines());
        }
        int zLevel = 400;
        RenderTooltipExtEvent.Color colorEvent = new RenderTooltipExtEvent.Color(stack, info.getLines(), matrixStack, rectX, rectY, info.getFont(), backgroundColorStart, backgroundColorEnd, borderColorStart, borderColorEnd, comparison, index);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColorStart = colorEvent.getBackgroundStart();
        backgroundColorEnd = colorEvent.getBackgroundEnd();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        matrixStack.func_227860_a_();
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY - 4), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY - 3), (int)backgroundColorStart, (int)backgroundColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY + rect.func_199317_d() + 3), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY + rect.func_199317_d() + 4), (int)backgroundColorEnd, (int)backgroundColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY - 3), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY + rect.func_199317_d() + 3), (int)backgroundColorStart, (int)backgroundColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 4), (int)(rectY - 3), (int)(rectX - 3), (int)(rectY + rect.func_199317_d() + 3), (int)backgroundColorStart, (int)backgroundColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX + rect.func_199316_c() + 3), (int)(rectY - 3), (int)(rectX + rect.func_199316_c() + 4), (int)(rectY + rect.func_199317_d() + 3), (int)backgroundColorStart, (int)backgroundColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY - 3 + 1), (int)(rectX - 3 + 1), (int)(rectY + rect.func_199317_d() + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX + rect.func_199316_c() + 2), (int)(rectY - 3 + 1), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY + rect.func_199317_d() + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY - 3), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(rectX - 3), (int)(rectY + rect.func_199317_d() + 2), (int)(rectX + rect.func_199316_c() + 3), (int)(rectY + rect.func_199317_d() + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipExtEvent.PostBackground(stack, info.getLines(), matrixStack, rectX, rectY, info.getFont(), rect.func_199316_c(), rect.func_199317_d(), comparison, index));
        IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixStack.func_227861_a_(0.0, 0.0, 400.0);
        int tooltipTop = rectY;
        for (int lineNumber = 0; lineNumber < info.getLines().size(); ++lineNumber) {
            ITextProperties line = info.getLines().get(lineNumber);
            if (line != null) {
                info.getFont().func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)rectX, (float)rectY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
            }
            if (lineNumber + 1 == info.getTitleLines()) {
                rectY += 2;
            }
            rectY += 10;
        }
        renderType.func_228461_a_();
        matrixStack.func_227865_b_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipExtEvent.PostText(stack, info.getLines(), matrixStack, rectX, tooltipTop, info.getFont(), rect.func_199316_c(), rect.func_199317_d(), comparison, index));
        RenderSystem.enableDepthTest();
        FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
        Matrix4f lastMatrix = matrixStack.func_227866_c_().func_227870_a_();
        lastMatrix.func_195879_b(matrixBuffer);
        float matrixX = matrixBuffer.get(3);
        float matrixY = matrixBuffer.get(7);
        lastMatrix.setTranslation(matrixX, matrixY, 400.0f);
    }

    public static Rectangle2d calculateRect(ItemStack stack, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font) {
        return Tooltips.calculateRect(stack, matrixStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font, 0, false);
    }

    public static Rectangle2d calculateRect(ItemStack stack, MatrixStack matrixStack, List<? extends ITextProperties> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, FontRenderer font, int minWidth, boolean centeredTitle) {
        Rectangle2d rect = new Rectangle2d(0, 0, 0, 0);
        if (textLines == null || textLines.isEmpty() || stack == null) {
            return rect;
        }
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, matrixStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return rect;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        TooltipInfo info = new TooltipInfo(textLines, font);
        int tooltipTextWidth = info.getMaxLineWidth(minWidth);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + tooltipTextWidth > screenWidth && (tooltipX -= 28 + tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 20 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            info.wrap(tooltipTextWidth, minWidth);
            tooltipTextWidth = info.getTooltipWidth();
        }
        if (centeredTitle) {
            info = new TooltipInfo(Tooltips.centerTitle(info.getLines(), info.getFont(), tooltipTextWidth, info.getTitleLines()), info.getFont(), info.getTitleLines());
            tooltipTextWidth = info.getTooltipWidth();
        }
        int tooltipHeight = info.getTooltipHeight();
        if (tooltipX < 6) {
            tooltipX = 6;
        }
        if (tooltipY < 6) {
            tooltipY = 6;
        }
        if (tooltipY + tooltipHeight + 6 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 6;
        }
        rect = new Rectangle2d(tooltipX - 2, tooltipY - 4, tooltipTextWidth, tooltipHeight);
        return rect;
    }

    public static List<? extends ITextProperties> centerTitle(List<? extends ITextProperties> textLines, FontRenderer font, int width, int titleLines) {
        ArrayList<? extends ITextProperties> result = new ArrayList<ITextProperties>(textLines);
        for (int i = 0; i < titleLines; ++i) {
            ITextProperties title = textLines.get(i);
            if (title == null) continue;
            while (font.func_238414_a_((ITextProperties)result.get(i)) < width && (title = ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{new StringTextComponent(" "), title, new StringTextComponent(" ")})) != null) {
                result.set(i, (ITextProperties)title);
            }
        }
        return result;
    }

    public static class TooltipInfo {
        private int tooltipWidth = 0;
        private int titleLines = 1;
        private FontRenderer font;
        private List<? extends ITextProperties> lines = new ArrayList<ITextProperties>();

        public TooltipInfo(List<? extends ITextProperties> lines, FontRenderer font) {
            this.lines = lines;
            this.font = font;
            this.tooltipWidth = this.getMaxLineWidth();
        }

        public TooltipInfo(List<? extends ITextProperties> lines, FontRenderer font, int titleLines) {
            this.lines = lines;
            this.font = font;
            this.titleLines = titleLines;
            this.tooltipWidth = this.getMaxLineWidth();
        }

        public int getTooltipWidth() {
            return this.tooltipWidth;
        }

        public int getTooltipHeight() {
            return this.lines.size() > this.titleLines ? this.lines.size() * 10 + 2 : 8;
        }

        public int getTitleLines() {
            return this.titleLines;
        }

        public FontRenderer getFont() {
            return this.font;
        }

        public List<? extends ITextProperties> getLines() {
            return this.lines;
        }

        public void setFont(FontRenderer font) {
            this.font = font;
        }

        public int getMaxLineWidth() {
            return this.getMaxLineWidth(0);
        }

        public int getMaxLineWidth(int minWidth) {
            int textWidth = minWidth;
            for (ITextProperties iTextProperties : this.lines) {
                int textLineWidth = this.font.func_238414_a_(iTextProperties);
                if (textLineWidth <= textWidth) continue;
                textWidth = textLineWidth;
            }
            return textWidth;
        }

        public void wrap(int maxWidth) {
            this.wrap(maxWidth, 0);
        }

        public void wrap(int maxWidth, int minWidth) {
            this.tooltipWidth = minWidth;
            ArrayList<? extends ITextProperties> wrappedLines = new ArrayList<ITextProperties>();
            for (int i = 0; i < this.lines.size(); ++i) {
                ITextProperties textLine = this.lines.get(i);
                List wrappedLine = this.font.func_238420_b_().func_238362_b_(textLine, maxWidth, Style.field_240709_b_);
                if (i == 0) {
                    this.titleLines = wrappedLine.size();
                }
                for (ITextProperties line : wrappedLine) {
                    int lineWidth = this.font.func_238414_a_(line);
                    if (lineWidth > this.tooltipWidth) {
                        this.tooltipWidth = lineWidth;
                    }
                    wrappedLines.add((ITextProperties)line);
                }
            }
            if (this.tooltipWidth > maxWidth) {
                this.tooltipWidth = maxWidth;
            }
            this.lines = wrappedLines;
        }
    }
}

