/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import com.anthonyhilyard.iceberg.util.ItemColor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;

public class Selectors {
    private static Map<String, Rarity> rarities = new HashMap<String, Rarity>(){
        {
            this.put("common", Rarity.COMMON);
            this.put("uncommon", Rarity.UNCOMMON);
            this.put("rare", Rarity.RARE);
            this.put("epic", Rarity.EPIC);
        }
    };
    private static Map<String, BiPredicate<INBT, String>> nbtComparators = new HashMap<String, BiPredicate<INBT, String>>(){
        {
            this.put("=", (tag, value) -> tag.func_150285_a_().contentEquals((CharSequence)value));
            this.put("!=", (tag, value) -> !tag.func_150285_a_().contentEquals((CharSequence)value));
            this.put(">", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumberNBT) {
                        return ((NumberNBT)tag).func_150286_g() > parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
            this.put("<", (tag, value) -> {
                try {
                    double parsedValue = Double.valueOf(value);
                    if (tag instanceof NumberNBT) {
                        return ((NumberNBT)tag).func_150286_g() < parsedValue;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
    };

    public static List<SelectorDocumentation> selectorDocumentation() {
        return Arrays.asList(new SelectorDocumentation("Item name", "Use item name for vanilla items or include mod name for modded items.", "minecraft:stick", "iron_ore"), new SelectorDocumentation("Tag", "$ followed by tag name.", "$forge:stone", "$planks"), new SelectorDocumentation("Mod name", "@ followed by mod identifier.", "@spoiledeggs"), new SelectorDocumentation("Rarity", "! followed by item's rarity.  This is ONLY vanilla rarities.", "!uncommon", "!rare", "!epic"), new SelectorDocumentation("Item name color", "# followed by color hex code, the hex code must match exactly.", "#23F632"), new SelectorDocumentation("Display name", "% followed by any text.  Will match any item with this text in its tooltip display name.", "%Netherite", "%[Uncommon]"), new SelectorDocumentation("Tooltip text", "Will match any item with this text anywhere in the tooltip text (besides the name).", "^Legendary"), new SelectorDocumentation("NBT tag", "& followed by tag name and optional comparator (=, >, <, or !=) and value, in the format <tag><comparator><value> or just <tag>.", "&Damage=0", "&Tier>1", "&map!=128", "&Enchantments"));
    }

    public static boolean validateSelector(String value) {
        if (value.startsWith("$")) {
            return ResourceLocation.func_217855_b((String)value.substring(1));
        }
        if (value.startsWith("@")) {
            return value.substring(1).matches("^[a-z][a-z0-9_-]{1,63}$");
        }
        if (value.startsWith("!")) {
            return rarities.keySet().contains(value.substring(1).toLowerCase());
        }
        if (value.startsWith("#")) {
            return Color.func_240745_a_((String)value) != null;
        }
        if (value.startsWith("%") || value.startsWith("^")) {
            return true;
        }
        if (value.startsWith("&")) {
            return true;
        }
        return value == null || value == "" || ResourceLocation.func_217855_b((String)value);
    }

    public static boolean itemMatches(ItemStack item, String selector) {
        String itemResourceLocation = item.func_77973_b().getRegistryName().toString();
        if (selector.equals(itemResourceLocation) || selector.equals(itemResourceLocation.replace("minecraft:", ""))) {
            return true;
        }
        if (selector.startsWith("#")) {
            Color entryColor = Color.func_240745_a_((String)selector);
            if (entryColor != null && entryColor.equals((Object)ItemColor.getColorForItem(item, Color.func_240743_a_((int)0xFFFFFF)))) {
                return true;
            }
        } else if (selector.startsWith("!")) {
            if (item.func_77953_t() == rarities.get(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("@")) {
            if (itemResourceLocation.startsWith(selector.substring(1) + ":")) {
                return true;
            }
        } else if (selector.startsWith("$")) {
            if (ItemTags.func_199903_a().func_241834_b(new ResourceLocation(selector.substring(1))).func_230236_b_().contains(item.func_77973_b())) {
                return true;
            }
        } else if (selector.startsWith("%")) {
            if (item.func_151000_E().getString().contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("^")) {
            Minecraft mc = Minecraft.func_71410_x();
            List lines = item.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
            String tooltipText = "";
            for (int n = 1; n < lines.size(); ++n) {
                tooltipText = tooltipText + ((ITextComponent)lines.get(n)).getString() + '\n';
            }
            if (tooltipText.contains(selector.substring(1))) {
                return true;
            }
        } else if (selector.startsWith("&")) {
            String tagName = selector.substring(1);
            String tagValue = null;
            BiPredicate<INBT, String> valueChecker = null;
            for (String comparator : nbtComparators.keySet()) {
                if (!tagName.contains(comparator)) continue;
                valueChecker = nbtComparators.get(comparator);
                String[] components = tagName.split(comparator);
                tagName = components[0];
                if (components.length <= 1) break;
                tagValue = components[1];
                break;
            }
            return Selectors.findMatchingSubtag((INBT)item.func_77978_p(), tagName, tagValue, valueChecker);
        }
        return false;
    }

    private static boolean findMatchingSubtag(INBT tag, String key, String value, BiPredicate<INBT, String> valueChecker) {
        if (tag == null) {
            return false;
        }
        if (tag.func_74732_a() == 10) {
            CompoundNBT compoundTag = (CompoundNBT)tag;
            if (compoundTag.func_74764_b(key)) {
                if (value == null && valueChecker == null) {
                    return true;
                }
                return valueChecker.test(compoundTag.func_74781_a(key), value);
            }
            for (String innerKey : compoundTag.func_150296_c()) {
                if (compoundTag.func_150299_b(innerKey) != 9 && compoundTag.func_150299_b(innerKey) != 10 || !Selectors.findMatchingSubtag(compoundTag.func_74781_a(innerKey), key, value, valueChecker)) continue;
                return true;
            }
            return false;
        }
        if (tag.func_74732_a() == 9) {
            ListNBT listTag = (ListNBT)tag;
            for (INBT innerTag : listTag) {
                if (innerTag.func_74732_a() != 9 && innerTag.func_74732_a() != 10 || !Selectors.findMatchingSubtag(innerTag, key, value, valueChecker)) continue;
                return true;
            }
        }
        return false;
    }

    public static class SelectorDocumentation {
        public final String name;
        public final String description;
        public final List<String> examples;

        public SelectorDocumentation(String name, String description, String ... examples) {
            this.name = name;
            this.description = description;
            this.examples = Arrays.asList(examples);
        }
    }
}

