/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.registry;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AutoRegistry {
    protected static String MODID = null;
    private static boolean entityCreationRegistered = false;
    private static Map<EntityType<?>, Supplier<AttributeModifierMap.MutableAttribute>> entityAttributes = new HashMap();
    private static Map<String, EntityType<? extends Entity>> registeredEntityTypes = new HashMap<String, EntityType<? extends Entity>>();

    public static void init(String ModID) {
        MODID = ModID;
    }

    protected AutoRegistry() {
        try {
            for (Field field : ForgeRegistries.class.getDeclaredFields()) {
                Object fieldObj = field.get(null);
                if (!(fieldObj instanceof IForgeRegistry)) continue;
                Class clazz = ((IForgeRegistry)fieldObj).getRegistrySuperType();
                FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(clazz, e -> this.registerAllOfType(clazz, (RegistryEvent.Register)e));
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static boolean isEntityTypeRegistered(String name) {
        return registeredEntityTypes.containsKey(name);
    }

    public static <T extends Entity> EntityType<T> getEntityType(String name) {
        return registeredEntityTypes.getOrDefault(name, null);
    }

    private final <T extends IForgeRegistryEntry<T>> void registerAllOfType(Class<IForgeRegistryEntry<?>> type, RegistryEvent.Register<T> event) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                IForgeRegistryEntry entry;
                Object obj = field.get(this);
                if (!type.isAssignableFrom(obj.getClass())) continue;
                if (obj instanceof EntityType && !entityCreationRegistered) {
                    FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEntityCreation);
                    entityCreationRegistered = true;
                }
                if ((entry = (IForgeRegistryEntry)obj) == null || entry.getRegistryName() == null) continue;
                event.getRegistry().register(entry);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder) {
        return AutoRegistry.registerEntity(name, builder, (Supplier<AttributeModifierMap.MutableAttribute>)null);
    }

    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
        return AutoRegistry.registerEntity(name, builder, null, attributes);
    }

    @Deprecated
    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder, IRenderFactory<? super T> renderFactory) {
        return AutoRegistry.registerEntity(name, builder, renderFactory, null);
    }

    @Deprecated
    protected static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder, IRenderFactory<? super T> renderFactory, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
        if (MODID == null) {
            throw new RuntimeException("AutoRegistry was not initialized with mod id!");
        }
        ResourceLocation resourceLocation = new ResourceLocation(MODID, name);
        EntityType entityType = (EntityType)builder.func_206830_a(name).setRegistryName(resourceLocation);
        registeredEntityTypes.put(name, (EntityType<? extends Entity>)entityType);
        if (attributes != null) {
            entityAttributes.put(entityType, attributes);
        }
        return entityType;
    }

    protected static SoundEvent registerSound(String name) {
        if (MODID == null) {
            throw new RuntimeException("AutoRegistry was not initialized with mod id!");
        }
        ResourceLocation resourceLocation = new ResourceLocation(MODID, name);
        return (SoundEvent)new SoundEvent(resourceLocation).setRegistryName(resourceLocation);
    }

    private void onEntityCreation(EntityAttributeCreationEvent event) {
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                EntityType entityType;
                Object obj = field.get(this);
                if (!EntityType.class.isAssignableFrom(obj.getClass()) || !entityAttributes.containsKey(obj) || (entityType = (EntityType)obj) == null) continue;
                event.put(entityType, entityAttributes.get(obj).get().func_233813_a_());
            }
            catch (ClassCastException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

