/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.network;

import com.anthonyhilyard.iceberg.events.NewItemPickupEvent;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;

public final class NewItemPickupEventPacket {
    private final UUID playerUUID;
    private final ItemStack item;

    public NewItemPickupEventPacket(UUID playerUUID, ItemStack item) {
        this.playerUUID = playerUUID;
        this.item = item;
    }

    public static void encode(NewItemPickupEventPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179252_a(msg.playerUUID);
        packetBuffer.func_150788_a(msg.item);
    }

    public static NewItemPickupEventPacket decode(PacketBuffer packetBuffer) {
        return new NewItemPickupEventPacket(packetBuffer.func_179253_g(), packetBuffer.func_150791_c());
    }

    public static void handle(NewItemPickupEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MinecraftForge.EVENT_BUS.post((Event)new NewItemPickupEvent(msg.playerUUID, msg.item)));
        context.setPacketHandled(true);
    }
}

