/*
 * Decompiled with CFR 0.152.
 */
package gg.chaldea.client.reset.packet;

import gg.chaldea.client.reset.packet.network.S2CReset;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.login.ClientLoginNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="clientresetpacket")
public class ClientReset {
    public ClientReset() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientReset::init);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        FMLHandshakeHandler.LOGGER.info(FMLHandshakeHandler.FMLHSMARKER, "Registering forge reset packet");
        FMLNetworkConstants.handshakeChannel.messageBuilder(S2CReset.class, 98).loginIndex(FMLHandshakeMessages.LoginIndexedMessage::getLoginIndex, FMLHandshakeMessages.LoginIndexedMessage::setLoginIndex).decoder(S2CReset::decode).encoder(S2CReset::encode).consumer(FMLHandshakeHandler.biConsumerFor(ClientReset::handleReset)).add();
        FMLHandshakeHandler.LOGGER.info(FMLHandshakeHandler.FMLHSMARKER, "Registered forge reset packet");
    }

    public static void handleReset(FMLHandshakeHandler handler, S2CReset msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        NetworkManager connection = context.getNetworkManager();
        if (context.getDirection() != NetworkDirection.LOGIN_TO_CLIENT && context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            connection.func_150718_a((ITextComponent)new StringTextComponent("Illegal packet received, terminating connection"));
            throw new IllegalStateException("Invalid packet received, aborting connection");
        }
        FMLHandshakeHandler.LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Received reset from server");
        if (!ClientReset.handleClear(context)) {
            return;
        }
        NetworkHooks.registerClientLoginChannel((NetworkManager)connection);
        connection.func_150723_a(ProtocolType.LOGIN);
        connection.func_150719_a((INetHandler)new ClientLoginNetHandler(connection, Minecraft.func_71410_x(), null, statusMessage -> {}));
        context.setPacketHandled(true);
        FMLNetworkConstants.handshakeChannel.reply((Object)new FMLHandshakeMessages.C2SAcknowledge(), new NetworkEvent.Context(connection, NetworkDirection.LOGIN_TO_CLIENT, 98));
        FMLHandshakeHandler.LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Reset complete");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleClear(NetworkEvent.Context context) {
        CompletableFuture future = context.enqueueWork(() -> {
            FMLHandshakeHandler.LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Clearing");
            ServerData serverData = Minecraft.func_71410_x().func_147104_D();
            if (Minecraft.func_71410_x().field_71441_e == null) {
                GameData.revertToFrozen();
            }
            Minecraft.func_71410_x().func_213231_b((Screen)new DirtMessageScreen((ITextComponent)new TranslationTextComponent("connect.negotiating")));
            try {
                context.getNetworkManager().channel().pipeline().remove("forge:forge_fixes");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                context.getNetworkManager().channel().pipeline().remove("forge:vanilla_filter");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Minecraft.func_71410_x().func_71351_a(serverData);
        });
        FMLHandshakeHandler.LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Waiting for clear to complete");
        try {
            future.get();
            FMLHandshakeHandler.LOGGER.debug("Clear complete, continuing reset");
            return true;
        }
        catch (Exception ex) {
            FMLHandshakeHandler.LOGGER.error(FMLHandshakeHandler.FMLHSMARKER, "Failed to clear, closing connection", (Throwable)ex);
            context.getNetworkManager().func_150718_a((ITextComponent)new StringTextComponent("Failed to clear, closing connection"));
            return false;
        }
    }
}

