/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.tileentity;

import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.init.registry.TileEntityRegistration;
import com.pixelmonmod.tcg.listener.TCGServerEventListeners;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class EssenceJarTileEntity
extends TileEntity {
    private int essence = 0;
    private double fillPercent = 0.0;
    private Color color = new Color(DyeColor.CYAN.getColorValue());
    private IFormattableTextComponent colorName = new TranslationTextComponent("color.minecraft." + DyeColor.CYAN.func_176762_d());

    public EssenceJarTileEntity() {
        super((TileEntityType)TileEntityRegistration.ESSENCE_JAR.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.save0(tag);
        return tag;
    }

    public void save0(CompoundNBT tag) {
        tag.func_74768_a("EssenceJarCount", this.essence);
        tag.func_74780_a("EssenceJarPercent", this.recalculateFillPercent());
        tag.func_74768_a("EssenceJarColorRed", this.color.getRed());
        tag.func_74768_a("EssenceJarColorGreen", this.color.getGreen());
        tag.func_74768_a("EssenceJarColorBlue", this.color.getBlue());
        tag.func_74778_a("EssenceJarColorName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.colorName));
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.load0(tag);
        super.func_230337_a_(state, tag);
    }

    private boolean load0(CompoundNBT tag) {
        this.essence = tag.func_74762_e("EssenceJarCount");
        this.fillPercent = tag.func_74769_h("EssenceJarPercent");
        if (tag.func_74764_b("EssenceJarColorRed")) {
            this.color = new Color(tag.func_74762_e("EssenceJarColorRed"), tag.func_74762_e("EssenceJarColorGreen"), tag.func_74762_e("EssenceJarColorBlue"));
            this.colorName = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("EssenceJarColorName"));
            return true;
        }
        return false;
    }

    public double recalculateFillPercent() {
        this.fillPercent = Math.min(1.0, (double)this.essence / (double)TCGConfigProxy.getConfig().getEssenceToFillJar());
        return MathHelper.func_151237_a((double)this.fillPercent, (double)0.0, (double)1.0);
    }

    public void func_70296_d() {
        this.recalculateFillPercent();
        super.func_70296_d();
        if (this.func_145831_w() == null || this.func_195044_w() == null) {
            return;
        }
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 11);
        this.func_145831_w().func_225524_e_().func_215568_a(this.field_174879_c);
    }

    public boolean setValuesFromItem(ItemStack stack) {
        return this.load0(stack.func_190925_c("BlockEntityTag"));
    }

    public void applyValuesToItem(ItemStack stack) {
        this.save0(stack.func_190925_c("BlockEntityTag"));
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager network, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(Minecraft.func_71410_x().field_71441_e.func_180495_p(packet.func_179823_a()), packet.func_148857_g());
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 11);
        this.func_145831_w().func_225524_e_().func_215568_a(this.field_174879_c);
    }

    public Color getColor() {
        return this.color;
    }

    public int getEssence() {
        return this.essence;
    }

    public int addEssence(int essence) {
        int current = this.essence + essence;
        int target = TCGConfigProxy.getConfig().getEssenceToFillJar();
        this.essence = Math.min(current, target);
        this.func_70296_d();
        if (this.func_145831_w() instanceof ServerWorld) {
            TCGServerEventListeners.playEssenceJarEffect(this.essence, essence, current, target, (ServerWorld)this.func_145831_w(), this.func_174877_v(), this.getColor());
        }
        return Math.max(0, current - target);
    }

    public void setEssence(int essence) {
        this.essence = essence;
        this.func_70296_d();
    }

    public double getFillPercent() {
        return this.recalculateFillPercent();
    }

    public double getFillPercentDirect() {
        return MathHelper.func_151237_a((double)this.fillPercent, (double)0.0, (double)1.0);
    }

    public boolean isFilled() {
        return this.fillPercent >= 1.0;
    }

    public EssenceJarTileEntity setColor(DyeColor dyeColor) {
        if (dyeColor != null) {
            return this.setColor(new Color(dyeColor.getColorValue())).setColorName(dyeColor);
        }
        return this;
    }

    public EssenceJarTileEntity setColor(Color color) {
        this.color = color;
        return this;
    }

    public EssenceJarTileEntity setColorName(DyeColor dyeColor) {
        return this.setColorName((IFormattableTextComponent)new TranslationTextComponent("color.minecraft." + dyeColor.func_176762_d()));
    }

    public EssenceJarTileEntity setColorName(IFormattableTextComponent colorName) {
        this.colorName = colorName;
        return this;
    }

    public IFormattableTextComponent getColorName() {
        return this.colorName;
    }
}

