/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class ScoopUp
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false);
        selector.getCardList().addAll(server.getPlayer(server.getCurrentTurn()).getActiveAndBenchCards(true));
        return selector;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return !trainer.getParameters().isEmpty();
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PokemonCardState pokemon = (PokemonCardState)trainer.getParameters().get(0);
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CommonCardState basic = null;
        if (pokemon.getData().getCardType() == CardType.BASIC) {
            basic = pokemon;
        }
        for (CommonCardState attachment : pokemon.getAttachments()) {
            if (basic != null || attachment.getData().getCardType() != CardType.BASIC) {
                player.getDiscardPile().add(attachment.getData());
                continue;
            }
            basic = attachment;
        }
        if (basic == null) {
            basic = pokemon;
        }
        if (basic != pokemon) {
            player.getDiscardPile().add(pokemon.getData());
        }
        if (player.getActiveCard() == pokemon) {
            player.setActiveCard(null);
        }
        for (int i = 0; i < player.getBenchCards().length; ++i) {
            if (player.getBenchCards()[i] != pokemon) continue;
            player.getBenchCards()[i] = null;
        }
        player.getHand().add(basic.getData());
    }

    @Override
    public boolean canPlaceOn(CardWithLocation card) {
        return card != null && card.getCard() != null && card.isMine() && (card.getLocation() == BoardLocation.Bench || card.getLocation() == BoardLocation.Active);
    }

    @Override
    public boolean canSkipSelector() {
        return true;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CommonCardState basic = null;
        if (pokemon.getData().getCardType() == CardType.BASIC) {
            basic = pokemon;
        }
        for (CommonCardState attachment : pokemon.getAttachments()) {
            if (basic != null || attachment.getData().getCardType() != CardType.BASIC) {
                player.getDiscardPile().add(attachment.getData());
                continue;
            }
            basic = attachment;
        }
        if (basic == null) {
            basic = pokemon;
        }
        if (basic != pokemon) {
            player.getDiscardPile().add(pokemon.getData());
        }
        if (player.getActiveCard() == pokemon) {
            player.setActiveCard(null);
        }
        for (int i = 0; i < player.getBenchCards().length; ++i) {
            if (player.getBenchCards()[i] != pokemon) continue;
            player.getBenchCards()[i] = null;
        }
        player.getHand().add(basic.getData());
    }
}

