/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class MrFuji
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return client.getMe().getActiveAndBenchCards().size() > 1;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == 1;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        return SelectorHelper.generateSelectorForBench(server.getPlayer(server.getCurrentTurn()), "card.FOSS58.effect.selector");
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        for (int i = 0; i < me.getBenchCards().length; ++i) {
            if (me.getBenchCards()[i] != trainer.getParameters().get(0)) continue;
            me.getDeck().add(me.getBenchCards()[i].getData());
            me.getBenchCards()[i].getAttachments().stream().forEach(attach -> me.getDeck().add(attach.getData()));
            me.getBenchCards()[i].getAttachments().clear();
            me.getBenchCards()[i] = null;
            LogicHelper.shuffleCardList(me.getDeck());
        }
    }

    @Override
    public boolean canPlaceOn(CardWithLocation card) {
        return card != null && card.getCard() != null && card.isMine() && card.getLocation() == BoardLocation.Bench;
    }

    @Override
    public boolean canSkipSelector() {
        return true;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        for (int i = 0; i < me.getBenchCards().length; ++i) {
            if (me.getBenchCards()[i] != pokemon) continue;
            me.getDeck().add(me.getBenchCards()[i].getData());
            me.getBenchCards()[i].getAttachments().stream().forEach(attach -> me.getDeck().add(attach.getData()));
            me.getBenchCards()[i].getAttachments().clear();
            me.getBenchCards()[i] = null;
            LogicHelper.shuffleCardList(me.getDeck());
        }
    }
}

