/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.List;

public class Gambler
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return true;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return true;
    }

    @Override
    public List<CoinSide> flipCoin() {
        ArrayList<CoinSide> coin = new ArrayList<CoinSide>();
        coin.add(CoinSide.getRandom());
        return coin;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        for (ImmutableCard c : me.getHand()) {
            me.getDeck().add(c);
        }
        me.getHand().clear();
        LogicHelper.shuffleCardList(me.getDeck());
        if (this.isCorrectCoinSide(server)) {
            me.drawCards(8, server);
        } else {
            me.drawCards(1, server);
        }
    }

    private boolean isCorrectCoinSide(GameServerState server) {
        return server.getCoinFlip() != null && server.getCoinFlip().getResults().get(0) == CoinSide.Head;
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

