/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class ClefairyDoll
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        PokemonCardState[] benchCards;
        for (PokemonCardState card : benchCards = client.getMe().getBenchCards()) {
            if (card != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return true;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        PokemonCardState[] bench = player.getBenchCards();
        for (int i = 0; i < bench.length; ++i) {
            if (bench[i] != null) continue;
            bench[i] = new PokemonCardState(this, trainer, server.getCurrentTurn());
            bench[i].setCardType(CardType.BASIC);
            break;
        }
    }

    @Override
    public boolean preventDiscard() {
        return true;
    }

    @Override
    public boolean showDiscardButton() {
        return true;
    }

    @Override
    public boolean canPlaceOn(CardWithLocation card) {
        return card != null && card.getCard() == null && (card.getLocation() == BoardLocation.Bench || card.getLocation() == BoardLocation.Active);
    }

    @Override
    public boolean canSkipSelector() {
        return true;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
        PokemonCardState card = new PokemonCardState(this, trainer, server.getCurrentTurn());
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        if (b == BoardLocation.Active) {
            player.setActiveCard(card);
            player.getActiveCard().setCardType(CardType.BASIC);
        } else if (b == BoardLocation.Bench) {
            player.getBenchCards()[p] = card;
            player.getBenchCards()[p].setCardType(CardType.BASIC);
        }
    }
}

