/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.state;

import com.pixelmonmod.pixelmon.api.util.helpers.ContainerHelper;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.duel.dto.CustomGUI;
import com.pixelmonmod.tcg.duel.state.AvailableActions;
import com.pixelmonmod.tcg.duel.state.CardSelectorResult;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CustomGUIResult;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.item.DeckItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class PlayerServerState
extends PlayerCommonState {
    private List<ImmutableCard> deck = new ArrayList<ImmutableCard>();
    private List<ImmutableCard> hand = new ArrayList<ImmutableCard>();
    private AvailableActions availableActions = new AvailableActions();
    private CardSelectorState cardSelectorState = null;
    private CardSelectorResult cardSelectorResult = null;
    private CustomGUI customGUI;
    private CustomGUIResult customGUIResult;
    protected PlayerEntity entityPlayer;
    private int openingPrizeIndex = -1;

    public PlayerServerState(PlayerEntity entityPlayer) {
        this.entityPlayer = entityPlayer;
        this.playerName = entityPlayer.func_145748_c_().getString();
    }

    public int drawCards(int count, GameServerState server) {
        int cardDrew = 0;
        for (int i = 0; i < count && this.deck.size() != 0; ++i) {
            this.hand.add(this.deck.get(0));
            if (this.entityPlayer.field_71071_by.func_70431_c(new ItemStack((IItemProvider)TCGItems.necklace))) {
                this.hand.add(this.deck.get(0));
            }
            this.deck.remove(0);
            ++cardDrew;
        }
        if (this.getEntityPlayer() == server.getPlayer(0).getEntityPlayer()) {
            server.getLog().trackDrawCard(cardDrew, 0, server);
        } else {
            server.getLog().trackDrawCard(cardDrew, 1, server);
        }
        return cardDrew;
    }

    public List<ImmutableCard> getDeck() {
        return this.deck;
    }

    @Override
    public List<ImmutableCard> getHand() {
        return this.hand;
    }

    public void setDeck(List<ImmutableCard> deck) {
        this.deck = deck;
    }

    public void setCardBack(String id) {
        this.cardBackID = id;
    }

    public void setCoinSet(String id) {
        this.coinSetID = id;
    }

    public AvailableActions getAvailableActions() {
        return this.availableActions;
    }

    public CardSelectorState getCardSelectorState() {
        return this.cardSelectorState;
    }

    public void setCardSelectorState(CardSelectorState cardSelectorState) {
        this.cardSelectorState = cardSelectorState;
    }

    public CardSelectorResult getCardSelectorResult() {
        return this.cardSelectorResult;
    }

    public void setCardSelectorResult(CardSelectorResult cardSelectorResult) {
        this.cardSelectorResult = cardSelectorResult;
    }

    public PlayerEntity getEntityPlayer() {
        return this.entityPlayer;
    }

    public void setEntityPlayer(PlayerEntity entityPlayer) {
        this.entityPlayer = entityPlayer;
    }

    public void setCounterEndTime(Date counterEndTime) {
        this.counterEndTime = counterEndTime;
    }

    public boolean hasPokemonLeft() {
        if (this.activeCard != null) {
            return true;
        }
        if (this.benchCards != null) {
            for (PokemonCardState card : this.benchCards) {
                if (card == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDeck() {
        return this.entityPlayer != null && !this.entityPlayer.func_184614_ca().func_190926_b() && this.entityPlayer.func_184614_ca().func_77973_b() instanceof DeckItem;
    }

    public void prepareDeck() {
        if (this.hasDeck()) {
            List<ImmutableCard> cards = LogicHelper.getCardsAndCosmetics(this.entityPlayer.func_184614_ca(), this);
            this.deck.clear();
            this.deck.addAll(cards);
            if (!this.entityPlayer.field_71071_by.func_70431_c(new ItemStack((IItemProvider)TCGItems.pendant))) {
                LogicHelper.shuffleCardList(this.deck);
            }
        }
    }

    public void switchActive(PokemonCardState benchCard, GameServerState server) {
        PokemonCardState oldActive = null;
        int benchIndex = 0;
        for (int i = 0; i < this.benchCards.length; ++i) {
            if (this.benchCards[i] != benchCard) continue;
            if (this.activeCard != null) {
                this.activeCard.getStatus().removeAllConditions();
            }
            oldActive = this.activeCard;
            benchIndex = i;
            this.benchCards[i] = this.activeCard;
            this.activeCard = benchCard;
            break;
        }
        for (PlayerServerState player : server.getPlayers()) {
            for (PokemonCardState pokemon : player.getActiveAndBenchCards()) {
                if (pokemon.getAbility() != null && pokemon.getAbility().getEffect() != null) {
                    pokemon.getAbility().getEffect().onSwitchActiveCard(this.activeCard, oldActive, this, pokemon, player, server);
                }
                if (pokemon.getHiddenAbility() == null || pokemon.getHiddenAbility().getEffect() == null) continue;
                pokemon.getHiddenAbility().getEffect().onSwitchActiveCard(this.activeCard, oldActive, this, pokemon, player, server);
            }
        }
        server.getLog().trackSwitch(this.activeCard, server.getTurn(this), server);
    }

    public CustomGUI getCustomGUI() {
        return this.customGUI;
    }

    public void setCustomGUI(CustomGUI customGUI) {
        this.customGUI = customGUI;
    }

    public CustomGUIResult getCustomGUIResult() {
        return this.customGUIResult;
    }

    public void useCustomGUIDefaultResult() {
        this.customGUIResult = this.customGUI.defaultResult;
    }

    public void setCustomGUIResult(CustomGUIResult customGUIResult) {
        this.customGUIResult = customGUIResult;
    }

    public void setPendingPrizeCount(int playerIndex, int pendingCount) {
        this.pendingPrizePlayerIndex = playerIndex;
        this.pendingPrizeCount = pendingCount;
        int count = 0;
        for (ImmutableCard card : this.prizeCards) {
            if (card == null) continue;
            ++count;
        }
        if (this.pendingPrizeCount > count) {
            this.pendingPrizeCount = count;
        }
        if (this.pendingPrizeCount < 0) {
            this.pendingPrizeCount = 0;
        }
    }

    public void addPendingPrizeCount(int playerIndex, int pendingPrizeCount) {
        this.setPendingPrizeCount(playerIndex, this.pendingPrizeCount + pendingPrizeCount);
    }

    public int getOpeningPrizeIndex() {
        return this.openingPrizeIndex;
    }

    public void setOpeningPrizeIndex(int openingPrizeIndex) {
        this.openingPrizeIndex = openingPrizeIndex;
    }

    public boolean hasItem(Item item) {
        return ContainerHelper.hasItem(item, this.getEntityPlayer());
    }
}

