/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.power;

import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.power.BasePowerEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerCommonState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;
import java.util.stream.Collectors;

public class Shift
extends BasePowerEffect {
    public Shift() {
        super("Shift");
    }

    @Override
    public boolean isEnabled(PokemonCardState pokemon, GameClientState client) {
        List<Energy> energies = this.getEnergies(pokemon, client.getMe(), client.getOpponent());
        return super.isEnabled(pokemon, client) && pokemon.getParameters().isEmpty() && !energies.isEmpty();
    }

    @Override
    public CardSelectorState getSelectorState(PokemonCardState pokemon, GameServerState server) {
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "power.shift.selector.change");
        this.getEnergies(pokemon, server.getPlayer(server.getCurrentTurn()), server.getPlayer(server.getNextTurn())).forEach(e -> selector.getCardList().add(new CardWithLocation(new CommonCardState(Cards.getEnergyCard(e)), true, null, 0)));
        return selector;
    }

    @Override
    public boolean canActivate(PokemonCardState pokemon, GameServerState client) {
        return !pokemon.getParameters().isEmpty();
    }

    @Override
    public void activate(PokemonCardState pokemon, GameServerState server, PlayerServerState player) {
        pokemon.setOverwriteEnergy(pokemon.getParameters().get(0).getMainEnergy());
    }

    @Override
    public void cleanUp(PokemonCardState pokemon, GameServerState server) {
    }

    private List<Energy> getEnergies(PokemonCardState pokemon, PlayerCommonState me, PlayerCommonState opp) {
        List<Energy> energies = me.getActiveAndBenchCards().stream().map(CommonCardState::getMainEnergy).collect(Collectors.toList());
        energies.addAll(opp.getActiveAndBenchCards().stream().map(CommonCardState::getMainEnergy).collect(Collectors.toList()));
        energies = energies.stream().distinct().collect(Collectors.toList());
        energies.remove((Object)pokemon.getMainEnergy());
        energies.remove((Object)Energy.COLORLESS);
        return energies;
    }
}

