/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.log;

import com.pixelmonmod.tcg.api.card.CardCondition;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.duel.log.DuelLogItem;
import com.pixelmonmod.tcg.duel.log.DuelLogType;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogAttachCardParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogAttackParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogCardParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogConditionParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogEndGameParameter;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogEvolveParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogIntParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogKnockoutParameters;
import com.pixelmonmod.tcg.duel.log.parameters.DuelLogStalemateParameter;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.Pair;

public class DuelLog {
    private final List<DuelLogItem> log;

    public DuelLog() {
        this.log = new ArrayList<DuelLogItem>();
    }

    public DuelLog(PacketBuffer buf) {
        int count = buf.readInt();
        this.log = new ArrayList<DuelLogItem>();
        for (int i = 0; i < count; ++i) {
            this.log.add(new DuelLogItem(buf));
        }
    }

    public void write(PacketBuffer buf, GamePhase gamePhase, int receiverIndex, boolean isMyTurn) {
        buf.writeInt(this.log.size());
        for (DuelLogItem item : this.log) {
            item.write(buf, gamePhase, receiverIndex, isMyTurn);
        }
    }

    public void saveLog(String location) throws IOException {
        File file = new File(location);
        file.createNewFile();
        FileWriter logFile = new FileWriter(file, true);
        for (DuelLogItem item : this.log) {
            logFile.write(item.toString() + "\n");
        }
        logFile.flush();
        logFile.close();
    }

    public void addItem(DuelLogItem item) {
        this.log.add(item);
    }

    public List<DuelLogItem> getItems(int count) {
        if (count > this.log.size()) {
            count = this.log.size();
        }
        ArrayList<DuelLogItem> result = new ArrayList<DuelLogItem>();
        int start = this.log.size() - 1;
        int end = this.log.size() - count;
        for (int i = start; i >= end && i >= 0; --i) {
            result.add(this.log.get(i));
        }
        return result;
    }

    public List<DuelLogItem> getItems() {
        return this.log;
    }

    public void trackAttack(CardAttack cardAttack, PokemonCardState attacker, PokemonCardState attacking, int damage, List<Pair<CardCondition, Integer>> conditions, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.ATTACK, new DuelLogAttackParameters(cardAttack, attacker, attacking, damage, conditions)));
    }

    public void trackAbility(PokemonCardState activator, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.ABILITY, new DuelLogCardParameters(activator)));
    }

    public void trackCondition(CardCondition cardCondition, PokemonCardState affected, int damage, boolean isHealed, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.CONDITION, new DuelLogConditionParameters(cardCondition, affected, damage, isHealed)));
    }

    public void trackKnockout(PokemonCardState dead, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.KNOCKOUT, new DuelLogKnockoutParameters(dead)));
    }

    public void trackPlayCard(CommonCardState played, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.PLAY, new DuelLogCardParameters(played)));
    }

    public void trackAttachCard(CommonCardState attachment, PokemonCardState host, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.ATTACH, new DuelLogAttachCardParameters(host, attachment)));
    }

    public void trackDrawCard(int count, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.DRAW, new DuelLogIntParameters(count)));
    }

    public void trackDiscard(CommonCardState discarded, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.DISCARD, new DuelLogCardParameters(discarded)));
    }

    public void trackEvolve(PokemonCardState prev, PokemonCardState next, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.EVOLVE, new DuelLogEvolveParameters(prev, next)));
    }

    public void trackSwitch(PokemonCardState in, int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.SWITCH, new DuelLogCardParameters(in)));
    }

    public void trackStartGame(GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), -1, DuelLogType.STARTGAME, null));
    }

    public void trackEndGame(int winnerIndex, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), -1, DuelLogType.ENDGAME, new DuelLogEndGameParameter(winnerIndex)));
    }

    public void trackStalemate(GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), -1, DuelLogType.ENDGAME, new DuelLogStalemateParameter()));
    }

    public void trackStartTurn(int playerSide, GameServerState state) {
        this.addItem(new DuelLogItem(state.getTurnCount(), playerSide, DuelLogType.PASSTURN, null));
    }
}

