/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffectWithOptionalFlip;
import com.pixelmonmod.tcg.duel.dto.CustomGUI;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CustomGUIResult;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class SwitchPokemonEffect
extends BaseAttackEffectWithOptionalFlip {
    private static final String[] CODES = new String[]{"SELF_SWITCH", "OPP_SWITCH"};
    private boolean myAction;
    private boolean myPokemons;
    private boolean isOptional;

    public SwitchPokemonEffect() {
        super(CODES);
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        PokemonCardState[] benchCards;
        if (this.isOptional) {
            PlayerServerState player = server.getPlayer(server.getCurrentTurn());
            if (player.getCustomGUIResult() == null || player.getCustomGUIResult().getResult() == null || player.getCustomGUIResult().getResult().length == 0) {
                return false;
            }
            player.setCustomGUI(null);
        }
        if (this.isOptional && server.getPlayer(server.getCurrentTurn()).getCustomGUIResult().getResult()[0] == 2) {
            return true;
        }
        for (PokemonCardState card : benchCards = server.getPlayer(this.myPokemons ? server.getCurrentTurn() : server.getNextTurn()).getBenchCards()) {
            if (card == null) continue;
            return parameters.size() == 1;
        }
        return true;
    }

    @Override
    public CustomGUI getCustomGUI(PokemonCardState pokemon, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        if (player.getCustomGUIResult() == null || player.getCustomGUIResult().getResult() == null || player.getCustomGUIResult().getResult().length == 0) {
            CustomGUIResult defaultResult = new CustomGUIResult();
            defaultResult.setOpened(true);
            defaultResult.setResult(new int[]{1});
            return new CustomGUI("GUI_OPTIONAL", defaultResult);
        }
        return null;
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (this.myAction) {
            return SelectorHelper.generateSelectorForBench(server.getPlayer(this.myPokemons ? server.getCurrentTurn() : server.getNextTurn()), null);
        }
        return null;
    }

    @Override
    public CardSelectorState getOpponentSelectorState(GameServerState server) {
        if (!this.myAction) {
            return SelectorHelper.generateSelectorForBench(server.getPlayer(this.myPokemons ? server.getCurrentTurn() : server.getNextTurn()), "attack.effect.switch.byopp");
        }
        return null;
    }

    @Override
    public void applyOnCorrectCoinSideAfterDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (!(parameters.isEmpty() || this.isOptional && server.getPlayer(server.getCurrentTurn()).getCustomGUIResult().getResult()[0] != 1)) {
            PokemonCardState bench = (PokemonCardState)parameters.get(0);
            server.getPlayer(this.myPokemons ? server.getCurrentTurn() : server.getNextTurn()).switchActive(bench, server);
        }
        server.getPlayer(server.getCurrentTurn()).setCustomGUIResult(null);
        server.getPlayer(server.getCurrentTurn()).setCustomGUI(null);
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        String[] types = args[0].split("_");
        this.myAction = this.myPokemons = types[0].equalsIgnoreCase("SELF");
        if (args.length > 1) {
            this.myAction = args[1].equalsIgnoreCase("BY_SELF");
        }
        return super.parse(args);
    }
}

