/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import java.util.List;

public class LeechSeedEffect
extends BaseAttackEffect {
    private static final String CODE = "LEECHSEED";
    private Type type;
    private int healAmount;

    public LeechSeedEffect() {
        super(CODE);
    }

    @Override
    public void applyAfterDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server, int finalDamage) {
        if (this.type == Type.FullDamage) {
            card.getStatus().healDamage(finalDamage);
        } else if (this.type == Type.HalfDamage) {
            card.getStatus().healDamage((int)(Math.ceil((double)finalDamage / 20.0) * 10.0));
        } else if (finalDamage > 0) {
            card.getStatus().healDamage(this.healAmount);
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        if (args[1].equalsIgnoreCase("DAMAGE")) {
            this.type = Type.FullDamage;
            this.healAmount = 0;
        } else if (args[1].equalsIgnoreCase("HALF_DAMAGE")) {
            this.type = Type.HalfDamage;
            this.healAmount = 0;
        } else {
            this.type = Type.Exact;
            this.healAmount = Integer.parseInt(args[1]);
        }
        return super.parse(args);
    }

    public static enum Type {
        Exact,
        FullDamage,
        HalfDamage;

    }
}

