/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.CardType;
import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;

public class AttachDiscardEffect
extends BaseAttackEffect {
    private static final String CODE = "ATTACHDISCARD";
    private CardType type;
    private int count;
    private Energy energy;

    public AttachDiscardEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        CardSelectorState selector = new CardSelectorState(1, this.count, CardSelectorDisplay.Select, false);
        int pos = 0;
        for (ImmutableCard card : player.getDiscardPile()) {
            if (card == null || card.getCardType() != this.type || this.energy != null && (this.energy == null || this.energy != card.getMainEnergy())) continue;
            selector.getCardList().add(new CardWithLocation(new CommonCardState(card), true, BoardLocation.DiscardPile, pos));
            ++pos;
        }
        if (selector.getCardList().size() == 0) {
            return null;
        }
        return selector;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        if (server.getPlayer(server.getCurrentTurn()).getDiscardPile().size() == 0) {
            return true;
        }
        if (this.getSelectorState(parameters, server) == null) {
            return true;
        }
        return parameters.size() > 0;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        for (int j = 0; j < parameters.size(); ++j) {
            CommonCardState selected = (CommonCardState)parameters.get(j);
            player.getDiscardPile().remove(selected.getData());
            player.getActiveCard().getAttachments().add(selected);
        }
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        if (args.length == 4) {
            this.type = CardType.getCardTypeFromString(args[2]);
            this.count = Integer.parseInt(args[1]);
            this.energy = Energy.getEnergyFromString(args[3]);
        } else {
            this.type = CardType.getCardTypeFromString(args[2]);
            this.count = Integer.parseInt(args[1]);
            this.energy = null;
        }
        return super.parse(args);
    }
}

